/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.podcast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.utils.DateUtils;

public final class PodcastFeedEntry
implements AudioObject,
Serializable,
Comparable<PodcastFeedEntry> {
    private static final long serialVersionUID = 4185336290582212484L;
    private static Comparator<PodcastFeedEntry> comparator = new Comparator<PodcastFeedEntry>(){

        @Override
        public int compare(PodcastFeedEntry podcastFeedEntry, PodcastFeedEntry podcastFeedEntry2) {
            return podcastFeedEntry.title.compareToIgnoreCase(podcastFeedEntry2.title);
        }
    };
    private String title;
    private String author;
    private String url;
    private String description;
    private int duration;
    private Date date;
    private PodcastFeed podcastFeed;
    private boolean listened;
    private boolean downloaded;
    private boolean old;

    public PodcastFeedEntry(String string, String string2, String string3, String string4, Date date, int n, PodcastFeed podcastFeed) {
        this.title = string;
        this.author = string2;
        this.url = string3;
        this.description = string4;
        this.date = date == null ? null : new Date(date.getTime());
        this.podcastFeed = podcastFeed;
        this.duration = n;
        this.listened = false;
    }

    public static Comparator<PodcastFeedEntry> getComparator() {
        return comparator;
    }

    public static List<PodcastFeedEntry> getPodcastFeedEntries(List<AudioObject> list) {
        ArrayList<PodcastFeedEntry> arrayList = new ArrayList<PodcastFeedEntry>();
        for (AudioObject audioObject : list) {
            if (!(audioObject instanceof PodcastFeedEntry)) continue;
            arrayList.add((PodcastFeedEntry)audioObject);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PodcastFeedEntry)) {
            return false;
        }
        return this.getUrl().equals(((PodcastFeedEntry)object).getUrl());
    }

    @Override
    public String getAlbum() {
        return this.getPodcastFeed().getName();
    }

    @Override
    public String getAlbumArtist() {
        return "";
    }

    @Override
    public String getAlbumArtistOrArtist() {
        return this.getAlbumArtist().isEmpty() ? this.getArtist() : this.getAlbumArtist();
    }

    @Override
    public String getArtist() {
        return this.author;
    }

    @Override
    public long getBitrate() {
        return 0L;
    }

    @Override
    public String getComposer() {
        return "";
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : new Date(this.date.getTime());
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public int getFrequency() {
        return 0;
    }

    @Override
    public String getGenre() {
        return "";
    }

    @Override
    public String getLyrics() {
        return "";
    }

    public void setOld(boolean bl) {
        this.old = bl;
    }

    public PodcastFeed getPodcastFeed() {
        return this.podcastFeed;
    }

    @Override
    public int getStars() {
        return 0;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getTitleOrFileName() {
        return this.getTitle();
    }

    @Override
    public int getTrackNumber() {
        return 0;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getYear() {
        if (this.date != null) {
            Calendar calendar = DateUtils.getCalendar();
            calendar.setTime(this.date);
            return String.valueOf(calendar.get(1));
        }
        return "";
    }

    @Override
    public String getComment() {
        return "";
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public boolean isListened() {
        return this.listened;
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isOld() {
        return this.old;
    }

    public void setDate(Date date) {
        this.date = date == null ? null : new Date(date.getTime());
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDownloaded(boolean bl) {
        this.downloaded = bl;
    }

    public void setListened(boolean bl) {
        this.listened = bl;
    }

    public void setPodcastFeed(PodcastFeed podcastFeed) {
        this.podcastFeed = podcastFeed;
    }

    @Override
    public void setStars(int n) {
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public boolean isSeekable() {
        return this.downloaded;
    }

    @Override
    public int compareTo(PodcastFeedEntry podcastFeedEntry) {
        return this.title.compareTo(podcastFeedEntry.title);
    }

    @Override
    public int getDiscNumber() {
        return 0;
    }

    @Override
    public ImageIcon getImage(ImageSize imageSize) {
        return null;
    }

    @Override
    public ImageIcon getGenericImage(GenericImageSize genericImageSize) {
        switch (genericImageSize) {
            case SMALL: {
                return Images.getImage("rss_little.png");
            }
            case MEDIUM: {
                return Images.getImage("rss.png");
            }
            case BIG: {
                return Images.getImage("rss_big.png");
            }
        }
        throw new IllegalArgumentException("unknown image size");
    }
}

