/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.AudioObjectComparator;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;

public final class SmartPlayListHandler {
    private Logger logger;
    private static SmartPlayListHandler instance;

    private SmartPlayListHandler() {
    }

    public static SmartPlayListHandler getInstance() {
        if (instance == null) {
            instance = new SmartPlayListHandler();
        }
        return instance;
    }

    public void addAlbumsMostPlayed(int n) {
        this.getLogger().debugMethodCall("HANDLER     ", Integer.toString(n));
        List<Album> list = StatisticsHandler.getInstance().getMostPlayedAlbums(n);
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (Album album : list) {
            arrayList.addAll(RepositoryHandler.getInstance().getAudioFilesForAlbums(Collections.singletonMap(album.getName(), album)));
        }
        AudioObjectComparator.sort(arrayList);
        PlayListHandler.getInstance().addToPlayList(arrayList);
    }

    public void addArtistsMostPlayed(int n) {
        this.getLogger().debugMethodCall("HANDLER     ", Integer.toString(n));
        List<Artist> list = StatisticsHandler.getInstance().getMostPlayedArtists(n);
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (Artist artist : list) {
            arrayList.addAll(artist.getAudioFiles());
        }
        List<AudioObject> list2 = AudioFile.getAudioObjects(arrayList);
        AudioObjectComparator.sort(list2);
        PlayListHandler.getInstance().addToPlayList((List<? extends AudioObject>)list2);
    }

    public void addRandomSongs(int n) {
        this.getLogger().debugMethodCall("HANDLER     ", Integer.toString(n));
        List<AudioFile> list = RepositoryHandler.getInstance().getAudioFilesList();
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        Random random = new Random(new Date().getTime());
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(list.size());
            arrayList.add(list.get(n2));
        }
        AudioObjectComparator.sort(arrayList);
        PlayListHandler.getInstance().addToPlayList(arrayList);
    }

    public void addSongsMostPlayed(int n) {
        this.getLogger().debugMethodCall("HANDLER     ", Integer.toString(n));
        List<AudioFile> list = StatisticsHandler.getInstance().getMostPlayedAudioFiles(n);
        List<AudioObject> list2 = AudioFile.getAudioObjects(list);
        AudioObjectComparator.sort(list2);
        PlayListHandler.getInstance().addToPlayList(list2);
    }

    public void addUnplayedSongs(int n) {
        this.getLogger().debugMethodCall("HANDLER     ", Integer.toString(n));
        List<AudioFile> list = StatisticsHandler.getInstance().getUnplayedAudioFiles();
        Collections.shuffle(list);
        int n2 = Math.min(list.size(), n);
        if (n2 > 0) {
            ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>(list.subList(0, n2));
            AudioObjectComparator.sort(arrayList);
            PlayListHandler.getInstance().addToPlayList(arrayList);
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

