/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

class PlaybackHistory {
    private Heap previousHeap = new Heap();
    private AudioObject currentAudioObject;
    private Heap nextHeap = new Heap();

    PlaybackHistory() {
    }

    AudioObject getPreviousInHistory(int n) {
        return this.previousHeap.get(n);
    }

    AudioObject getNextInHistory(int n) {
        return this.nextHeap.get(n);
    }

    AudioObject moveToPreviousInHistory() {
        AudioObject audioObject = this.previousHeap.pop();
        if (audioObject != null) {
            if (this.currentAudioObject != null) {
                this.nextHeap.push(this.currentAudioObject);
            }
            this.currentAudioObject = audioObject;
            return audioObject;
        }
        return null;
    }

    AudioObject moveToNextInHistory() {
        AudioObject audioObject = this.nextHeap.pop();
        if (audioObject != null) {
            if (this.currentAudioObject != null) {
                this.previousHeap.push(this.currentAudioObject);
                this.currentAudioObject = audioObject;
            }
            return audioObject;
        }
        return null;
    }

    void addToHistory(AudioObject audioObject) {
        if (this.currentAudioObject != null && this.currentAudioObject != audioObject) {
            if (this.previousHeap.get(1) == audioObject) {
                this.currentAudioObject = this.previousHeap.pop();
            } else if (this.nextHeap.get(1) == audioObject) {
                this.currentAudioObject = this.nextHeap.pop();
            } else {
                this.previousHeap.push(this.currentAudioObject);
                this.currentAudioObject = audioObject;
            }
        }
    }

    void remove(List<AudioObject> list) {
        for (AudioObject audioObject : list) {
            this.previousHeap.remove(audioObject);
            this.nextHeap.remove(audioObject);
        }
    }

    void clear() {
        this.previousHeap.clear();
        this.nextHeap.clear();
        this.currentAudioObject = null;
    }

    public String toString() {
        return StringUtils.getString(this.previousHeap.toString(), this.currentAudioObject, this.nextHeap.toString());
    }

    static class Heap {
        private List<AudioObject> heap = new ArrayList<AudioObject>();

        Heap() {
        }

        AudioObject pop() {
            if (this.heap.isEmpty()) {
                return null;
            }
            AudioObject audioObject = this.heap.get(this.heap.size() - 1);
            this.heap.remove(this.heap.size() - 1);
            return audioObject;
        }

        void push(AudioObject audioObject) {
            this.heap.add(audioObject);
        }

        AudioObject get(int n) {
            int n2 = this.heap.size() - n;
            if (!this.heap.isEmpty() && n2 >= 0 && n2 < this.heap.size()) {
                return this.heap.get(n2);
            }
            return null;
        }

        void remove(AudioObject audioObject) {
            while (this.heap.contains(audioObject)) {
                this.heap.remove(audioObject);
            }
        }

        void clear() {
            this.heap.clear();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (AudioObject audioObject : this.heap) {
                stringBuilder.append(audioObject).append(" <- ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

