/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.util.Comparator;
import net.sourceforge.atunes.gui.model.AbstractColumnSetTableModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.columns.PlayListColumnSet;
import net.sourceforge.atunes.kernel.modules.playlist.PlayList;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.model.AudioObject;

public class PlayListTableModel
extends AbstractColumnSetTableModel {
    private PlayList visiblePlayList = null;

    public PlayListTableModel() {
        super(PlayListColumnSet.getInstance());
    }

    @Override
    public int getRowCount() {
        if (this.visiblePlayList != null) {
            return this.visiblePlayList.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.visiblePlayList != null) {
            return this.getColumn(n2).getValueFor(this.visiblePlayList.get(n));
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.getColumn(n2).isEditable();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        AudioObject audioObject = this.visiblePlayList.get(n);
        this.getColumn(n2).setValueFor(audioObject, object);
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        RepositoryHandler.getInstance().getRepository().setDirty(true);
    }

    public void setVisiblePlayList(PlayList playList) {
        this.visiblePlayList = playList;
    }

    @Override
    public void sort(Comparator<AudioObject> comparator) {
        if (comparator == null) {
            return;
        }
        if (this.visiblePlayList == null || this.visiblePlayList.isEmpty()) {
            return;
        }
        this.visiblePlayList.sort(comparator);
    }
}

