/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListIO;
import net.sourceforge.atunes.kernel.modules.process.AbstractProcess;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

class LoadPlayListProcess
extends AbstractProcess {
    private List<String> filenamesToLoad;

    LoadPlayListProcess(List<String> list) {
        this.filenamesToLoad = list;
    }

    @Override
    protected long getProcessSize() {
        return this.filenamesToLoad.size();
    }

    @Override
    protected String getProgressDialogTitle() {
        return I18nUtils.getString("LOADING");
    }

    @Override
    protected void runCancel() {
    }

    @Override
    protected boolean runProcess() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (int i = 0; i < this.filenamesToLoad.size() && !this.isCanceled(); ++i) {
            arrayList.add(PlayListIO.getAudioFileOrCreate(this.filenamesToLoad.get(i)));
            this.setCurrentProgress(i + 1);
        }
        SwingUtilities.invokeLater(new AddToPlayListRunnable(arrayList));
        return true;
    }

    private static class AddToPlayListRunnable
    implements Runnable {
        private List<AudioObject> songsLoaded;

        public AddToPlayListRunnable(List<AudioObject> list) {
            this.songsLoaded = list;
        }

        @Override
        public void run() {
            if (this.songsLoaded.size() >= 1) {
                PlayListHandler.getInstance().addToPlayList(this.songsLoaded);
            }
        }
    }
}

