/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import java.util.regex.Pattern;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.player.mplayer.AbstractMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerEngine;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;

class RadioMPlayerOutputReader
extends AbstractMPlayerOutputReader {
    private static final Pattern END_PATTERN = Pattern.compile(".*\\x2e\\x2e\\x2e.*\\(.*\\).*");
    private Radio radio;
    private String lastArtist = "";
    private String lastTitle = "";
    private boolean started;

    RadioMPlayerOutputReader(MPlayerEngine mPlayerEngine, Process process, Radio radio) {
        super(mPlayerEngine, process);
        this.radio = radio;
    }

    @Override
    protected void init() {
        super.init();
        this.getEngine().setCurrentLength(this.radio.getDuration() * 1000);
    }

    @Override
    protected void read(String string) {
        super.read(string);
        if (string.startsWith("Starting playback")) {
            GuiHandler.getInstance().updateStatusBar(this.radio);
            if (!this.started) {
                this.getEngine().notifyRadioOrPodcastFeedEntry();
                this.started = true;
            }
        }
        if (string.startsWith("AUDIO:")) {
            String[] stringArray = string.split(" ");
            if (stringArray.length >= 2) {
                try {
                    this.radio.setFrequency(Integer.parseInt(stringArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger().info("PLAYER      ", "Could not read radio frequency");
                }
            }
            if (stringArray.length >= 7) {
                try {
                    this.radio.setBitrate((long)Double.parseDouble(stringArray[6]));
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger().info("PLAYER      ", "Could not read radio bitrate");
                }
            }
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        }
        if (ApplicationState.getInstance().isReadInfoFromRadioStream() && string.startsWith("ICY Info:")) {
            try {
                int n = string.indexOf("StreamTitle=");
                int n2 = string.indexOf(59, n);
                String string2 = string.substring(n + 13, n2 - 1);
                int n3 = string2.indexOf(45);
                String string3 = string2.substring(0, n3).trim();
                this.radio.setArtist(string3);
                String string4 = string2.substring(n3 + 1, string2.length()).trim();
                this.radio.setTitle(string4);
                this.radio.setSongInfoAvailable(true);
                ControllerProxy.getInstance().getPlayListController().refreshPlayList();
                if (!(string4.equals(this.lastTitle) && string3.equals(this.lastArtist) || !this.radio.equals(PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList()))) {
                    ContextHandler.getInstance().retrieveInfoAndShowInPanel(this.radio);
                }
                this.lastArtist = string3;
                this.lastTitle = string4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.getLogger().info("PLAYER      ", "Could not read song info from radio");
            }
        }
        if (END_PATTERN.matcher(string).matches()) {
            this.radio.deleteSongInfo();
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        }
    }
}

