/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.AbstractMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerEngine;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.I18nUtils;

class MPlayerErrorReader
extends Thread {
    private MPlayerEngine engine;
    private BufferedReader in;
    private AudioObject audioObject;
    private AbstractMPlayerOutputReader outputReader;

    MPlayerErrorReader(MPlayerEngine mPlayerEngine, Process process, AbstractMPlayerOutputReader abstractMPlayerOutputReader, AudioObject audioObject) {
        this.engine = mPlayerEngine;
        this.in = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.audioObject = audioObject;
        this.outputReader = abstractMPlayerOutputReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = null;
        try {
            while ((string = this.in.readLine()) != null && !this.isInterrupted()) {
                if (!string.startsWith("File not found")) continue;
                this.outputReader.stopRead();
                this.engine.currentAudioObjectFinished(false, I18nUtils.getString("FILE_NOT_FOUND"), ": ", this.audioObject.getUrl());
            }
        }
        catch (IOException iOException) {
            this.engine.handlePlayerEngineError(iOException);
        }
        finally {
            ClosingUtils.close(this.in);
        }
    }
}

