/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JSlider;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;

public class Equalizer {
    private Logger logger;
    private Map<String, Integer[]> presets = this.getPresetsFromBundle();

    private Map<String, Integer[]> getPresetsFromBundle() {
        HashMap<String, Integer[]> hashMap = new HashMap<String, Integer[]>();
        try {
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(Equalizer.class.getResourceAsStream("/settings/presets.properties"));
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = propertyResourceBundle.getString(string);
                string = string.replace('.', ' ');
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                Integer[] integerArray = new Integer[10];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    integerArray[n++] = Integer.parseInt(string3);
                }
                hashMap.put(string, integerArray);
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("PLAYER      ", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.getLogger().error("PLAYER      ", numberFormatException);
        }
        return hashMap;
    }

    public String[] getPresetsNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.presets.keySet());
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Integer[] getPresetByNameForShowInGUI(String string) {
        Integer[] integerArray = this.presets.get(string);
        Integer[] integerArray2 = new Integer[10];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray2[i] = integerArray[i] - 31;
        }
        return integerArray2;
    }

    public void setEqualizerFromGUI(JSlider[] jSliderArray) {
        float[] fArray = new float[10];
        for (int i = 0; i < jSliderArray.length; ++i) {
            fArray[i] = (float)(jSliderArray[i].getValue() * 12) / -32.0f;
        }
        ApplicationState.getInstance().setEqualizerSettings(fArray);
        if (PlayerHandler.getInstance().supportsCapability(PlayerEngineCapability.EQUALIZER_CHANGE)) {
            PlayerHandler.getInstance().applyEqualization(fArray);
        }
    }

    public int[] getEqualizerSettingsToShowInGUI() {
        float[] fArray = this.getEqualizerValues();
        if (fArray == null) {
            return new int[10];
        }
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = (int)(fArray[i] * 32.0f / -12.0f);
        }
        return nArray;
    }

    public float[] getEqualizerValues() {
        float[] fArray = ApplicationState.getInstance().getEqualizerSettings();
        return fArray != null ? Arrays.copyOf(fArray, fArray.length) : null;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

