/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellDecorator;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.gui.views.controls.NavigationTree;
import net.sourceforge.atunes.gui.views.decorators.PodcastFeedTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.StringTreeCellDecorator;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddPodcastFeedAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAfterCurrentAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.CopyToDeviceAction;
import net.sourceforge.atunes.kernel.actions.DownloadPodcastEntryAction;
import net.sourceforge.atunes.kernel.actions.MarkPodcastEntryListenedAction;
import net.sourceforge.atunes.kernel.actions.MarkPodcastListenedAction;
import net.sourceforge.atunes.kernel.actions.PlayNowAction;
import net.sourceforge.atunes.kernel.actions.RemoveFromDiskAction;
import net.sourceforge.atunes.kernel.actions.RemoveOldPodcastEntryAction;
import net.sourceforge.atunes.kernel.actions.RemovePodcastFeedAction;
import net.sourceforge.atunes.kernel.actions.RenamePodcastFeedAction;
import net.sourceforge.atunes.kernel.actions.SetAsPlayListAction;
import net.sourceforge.atunes.kernel.actions.ShowNavigatorTableItemInfoAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.columns.DateColumn;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractCustomNavigatorColumnSet;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class PodcastNavigationView
extends AbstractNavigationView {
    private List<AbstractTreeCellDecorator> decorators;
    private JTree podcastFeedTree;
    private JPopupMenu podcastFeedTreeMenu;
    private JPopupMenu podcastFeedTableMenu;
    private AbstractColumnSet columnSet;

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("rss_little.png");
    }

    @Override
    public String getTitle() {
        return I18nUtils.getString("PODCAST_FEEDS");
    }

    @Override
    public String getTooltip() {
        return I18nUtils.getString("PODCAST_FEED_TAB_TOOLTIP");
    }

    @Override
    public JTree getTree() {
        if (this.podcastFeedTree == null) {
            this.podcastFeedTree = new NavigationTree(new DefaultTreeModel(new DefaultMutableTreeNode(I18nUtils.getString("PODCAST_FEEDS"))));
            this.podcastFeedTree.setToggleClickCount(0);
            this.podcastFeedTree.setCellRenderer(this.getTreeRenderer());
            this.podcastFeedTree.getSelectionModel().setSelectionMode(1);
        }
        return this.podcastFeedTree;
    }

    @Override
    public JPopupMenu getTreePopupMenu() {
        if (this.podcastFeedTreeMenu == null) {
            this.podcastFeedTreeMenu = new JPopupMenu();
            this.podcastFeedTreeMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.podcastFeedTreeMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.podcastFeedTreeMenu.add(new JSeparator());
            this.podcastFeedTreeMenu.add(Actions.getAction(AddPodcastFeedAction.class));
            this.podcastFeedTreeMenu.add(Actions.getAction(RenamePodcastFeedAction.class));
            this.podcastFeedTreeMenu.add(Actions.getAction(MarkPodcastListenedAction.class));
            this.podcastFeedTreeMenu.add(Actions.getAction(RemovePodcastFeedAction.class));
        }
        return this.podcastFeedTreeMenu;
    }

    @Override
    public JPopupMenu getTablePopupMenu() {
        if (this.podcastFeedTableMenu == null) {
            this.podcastFeedTableMenu = new JPopupMenu();
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(AddToPlayListAfterCurrentAudioObjectAction.class));
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.podcastFeedTableMenu.add(Actions.getAction(PlayNowAction.class));
            this.podcastFeedTableMenu.add(new JSeparator());
            this.podcastFeedTableMenu.add(Actions.getAction(ShowNavigatorTableItemInfoAction.class));
            this.podcastFeedTableMenu.add(new JSeparator());
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(DownloadPodcastEntryAction.class));
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(RemoveOldPodcastEntryAction.class));
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(MarkPodcastEntryListenedAction.class));
            this.podcastFeedTableMenu.add(new JSeparator());
            this.podcastFeedTableMenu.add(this.getMenuItemForAction(CopyToDeviceAction.class));
            this.podcastFeedTableMenu.add(new JSeparator());
            this.podcastFeedTableMenu.add(Actions.getAction(RemoveFromDiskAction.class));
        }
        return this.podcastFeedTableMenu;
    }

    @Override
    protected Map<String, ?> getViewData(NavigationController.ViewMode viewMode) {
        HashMap<String, List<PodcastFeed>> hashMap = new HashMap<String, List<PodcastFeed>>();
        hashMap.put("PODCASTS", PodcastFeedHandler.getInstance().getPodcastFeeds());
        return hashMap;
    }

    @Override
    protected void refreshTree(NavigationController.ViewMode viewMode, String string) {
        this.debug("Refreshing ", this.getClass().getName());
        Map<String, ?> map = this.getViewData(viewMode);
        int[] nArray = this.getTree().getSelectionRows();
        int n = ((List)map.get("PODCASTS")).size();
        int n2 = this.getTree().getModel().getChildCount(this.getTree().getModel().getRoot());
        if (n != n2) {
            nArray = null;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultMutableTreeNode.setUserObject(I18nUtils.getString("PODCAST_FEEDS"));
        defaultMutableTreeNode.removeAllChildren();
        PodcastNavigationView.addPodcastFeedNodes((List)map.get("PODCASTS"), defaultMutableTreeNode, string);
        defaultTreeModel.reload();
        if (nArray != null) {
            this.getTree().setSelectionRows(nArray);
        } else {
            this.getTree().setSelectionRow(0);
        }
        this.getTree().expandRow(0);
    }

    @Override
    public List<AudioObject> getAudioObjectForTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, NavigationController.ViewMode viewMode, String string) {
        ArrayList<AudioObject> arrayList = new ArrayList();
        if (defaultMutableTreeNode.isRoot()) {
            if (string == null) {
                List<PodcastFeed> list = PodcastFeedHandler.getInstance().getPodcastFeeds();
                for (PodcastFeed podcastFeed : list) {
                    arrayList.addAll(podcastFeed.getAudioObjects());
                }
            } else {
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    PodcastFeed podcastFeed = (PodcastFeed)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                    arrayList.addAll(podcastFeed.getAudioObjects());
                }
            }
        } else {
            PodcastFeed podcastFeed = (PodcastFeed)defaultMutableTreeNode.getUserObject();
            arrayList = podcastFeed.getAudioObjects();
        }
        return arrayList;
    }

    private static void addPodcastFeedNodes(List<PodcastFeed> list, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (list == null) {
            return;
        }
        for (PodcastFeed podcastFeed : list) {
            if (string != null && !podcastFeed.getName().toUpperCase().contains(string.toUpperCase())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(podcastFeed);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    @Override
    public boolean isUseDefaultNavigatorColumnSet() {
        return false;
    }

    @Override
    public AbstractColumnSet getCustomColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new PodcastNavigationColumnSet(this.getClass().getName());
        }
        return this.columnSet;
    }

    @Override
    public boolean isViewModeSupported() {
        return false;
    }

    @Override
    protected List<AbstractTreeCellDecorator> getTreeCellDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList<AbstractTreeCellDecorator>();
            this.decorators.add(new StringTreeCellDecorator());
            this.decorators.add(new PodcastFeedTreeCellDecorator());
        }
        return this.decorators;
    }

    private static class PodcastNavigationColumnSet
    extends AbstractCustomNavigatorColumnSet {
        public PodcastNavigationColumnSet(String string) {
            super(string);
        }

        @Override
        protected List<AbstractColumn> getAllowedColumns() {
            ArrayList<AbstractColumn> arrayList = new ArrayList<AbstractColumn>();
            NotListenedPropertyColumn notListenedPropertyColumn = new NotListenedPropertyColumn("", NavigationTableModel.Property.class);
            notListenedPropertyColumn.setVisible(true);
            notListenedPropertyColumn.setWidth(20);
            notListenedPropertyColumn.setResizable(false);
            arrayList.add(notListenedPropertyColumn);
            DownloadedPropertyColumn downloadedPropertyColumn = new DownloadedPropertyColumn("", NavigationTableModel.Property.class);
            downloadedPropertyColumn.setVisible(true);
            downloadedPropertyColumn.setWidth(20);
            downloadedPropertyColumn.setResizable(false);
            arrayList.add(downloadedPropertyColumn);
            OldEntryPropertyColumn oldEntryPropertyColumn = new OldEntryPropertyColumn("", NavigationTableModel.Property.class);
            oldEntryPropertyColumn.setVisible(true);
            oldEntryPropertyColumn.setWidth(20);
            oldEntryPropertyColumn.setResizable(false);
            arrayList.add(oldEntryPropertyColumn);
            PodcastEntriesColumn podcastEntriesColumn = new PodcastEntriesColumn("PODCAST_ENTRIES", String.class);
            podcastEntriesColumn.setVisible(true);
            podcastEntriesColumn.setWidth(300);
            podcastEntriesColumn.setUsedForFilter(true);
            arrayList.add(podcastEntriesColumn);
            DurationColumn durationColumn = new DurationColumn("DURATION", String.class);
            durationColumn.setVisible(true);
            durationColumn.setWidth(60);
            durationColumn.setUsedForFilter(true);
            arrayList.add(durationColumn);
            DateColumn dateColumn = new DateColumn();
            dateColumn.setVisible(true);
            dateColumn.setUsedForFilter(true);
            arrayList.add(dateColumn);
            return arrayList;
        }

        private static final class NotListenedPropertyColumn
        extends AbstractColumn {
            private static final long serialVersionUID = 1L;

            private NotListenedPropertyColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return ((PodcastFeedEntry)audioObject).isListened() ? NavigationTableModel.Property.NO_PROPERTIES : NavigationTableModel.Property.NOT_LISTENED_ENTRY;
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return Boolean.valueOf(((PodcastFeedEntry)audioObject).isListened()).compareTo(((PodcastFeedEntry)audioObject2).isListened());
            }
        }

        private static final class DownloadedPropertyColumn
        extends AbstractColumn {
            private static final long serialVersionUID = 1L;

            private DownloadedPropertyColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return ((PodcastFeedEntry)audioObject).isDownloaded() ? NavigationTableModel.Property.DOWNLOADED_ENTRY : NavigationTableModel.Property.NO_PROPERTIES;
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return Boolean.valueOf(((PodcastFeedEntry)audioObject).isDownloaded()).compareTo(((PodcastFeedEntry)audioObject2).isDownloaded());
            }
        }

        private static final class OldEntryPropertyColumn
        extends AbstractColumn {
            private static final long serialVersionUID = 1L;

            private OldEntryPropertyColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return ((PodcastFeedEntry)audioObject).isOld() ? NavigationTableModel.Property.OLD_ENTRY : NavigationTableModel.Property.NO_PROPERTIES;
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return Boolean.valueOf(((PodcastFeedEntry)audioObject).isOld()).compareTo(((PodcastFeedEntry)audioObject2).isOld());
            }
        }

        private static final class PodcastEntriesColumn
        extends AbstractColumn {
            private static final long serialVersionUID = -1788596965509543581L;

            private PodcastEntriesColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return audioObject.getTitleOrFileName();
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return audioObject.getTitleOrFileName().compareTo(audioObject2.getTitleOrFileName());
            }
        }

        private static final class DurationColumn
        extends AbstractColumn {
            private static final long serialVersionUID = -5577224920500040774L;

            private DurationColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return StringUtils.seconds2String(audioObject.getDuration());
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return Integer.valueOf(audioObject.getDuration()).compareTo(audioObject2.getDuration());
            }
        }
    }
}

