/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.youtube;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.context.ContextImageJTable;
import net.sourceforge.atunes.kernel.modules.context.youtube.YoutubeDataSource;
import net.sourceforge.atunes.kernel.modules.context.youtube.YoutubeResultTableModel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.internetsearch.SearchFactory;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeResultEntry;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeService;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeVideoDownloader;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jfree.ui.ExtensionFileFilter;

public class YoutubeContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = 5041098100868186051L;
    private ContextImageJTable youtubeResultTable;

    public YoutubeContent() {
        super(new YoutubeDataSource());
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("YOUTUBE_VIDEOS");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, AudioObject> hashMap = new HashMap<String, AudioObject>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        if (map.containsKey("VIDEOS")) {
            this.youtubeResultTable.setModel(new YoutubeResultTableModel((List)map.get("VIDEOS")));
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.youtubeResultTable.setModel(new YoutubeResultTableModel(null));
    }

    @Override
    protected Component getComponent() {
        this.youtubeResultTable = new ContextImageJTable();
        this.youtubeResultTable.setSelectionMode(0);
        this.youtubeResultTable.setShowGrid(false);
        this.youtubeResultTable.getTableHeader().setReorderingAllowed(false);
        this.youtubeResultTable.setDefaultRenderer(YoutubeResultEntry.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new YoutubeResultsTableCellRendererCode()));
        this.youtubeResultTable.setColumnSelectionAllowed(false);
        JMenuItem jMenuItem = new JMenuItem(I18nUtils.getString("PLAY_VIDEO_AT_YOUTUBE"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YoutubeContent.this.playVideoAtYoutube();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(I18nUtils.getString("DOWNLOAD_VIDEO"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YoutubeContent.this.downloadVideo();
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.setInvoker(this.youtubeResultTable);
        this.youtubeResultTable.addMouseListener(new YoutubeResultsTableMouseAdapter(jPopupMenu));
        return this.youtubeResultTable;
    }

    @Override
    protected List<Component> getOptions() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        JMenuItem jMenuItem = new JMenuItem(I18nUtils.getString("SEE_MORE_RESULTS"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YoutubeContent.this.searchMoreResultsInYoutube();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(I18nUtils.getString("GO_TO_YOUTUBE"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YoutubeContent.this.openYoutube();
            }
        });
        arrayList.add(jMenuItem);
        arrayList.add(jMenuItem2);
        return arrayList;
    }

    protected void downloadVideo() {
        int n = this.youtubeResultTable.getSelectedRow();
        if (n != -1) {
            YoutubeResultEntry youtubeResultEntry = ((YoutubeResultTableModel)this.youtubeResultTable.getModel()).getEntry(n);
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(I18nUtils.getString("SAVE_YOUTUBE_VIDEO"));
            jFileChooser.setFileFilter((FileFilter)new ExtensionFileFilter("MP4", "MP4"));
            File file = new File(FileNameUtils.getValidFileName(youtubeResultEntry.getName().replace("\\", "\\\\").replace("$", "\\$").replace('[', ' ').replace(']', ' ')));
            jFileChooser.setSelectedFile(file);
            int n2 = jFileChooser.showSaveDialog(GuiHandler.getInstance().getFrame().getFrame());
            File file2 = jFileChooser.getSelectedFile();
            if (file2 != null && 0 == n2) {
                this.downloadYoutubeVideo(youtubeResultEntry, file2);
            }
        }
    }

    protected void downloadYoutubeVideo(YoutubeResultEntry youtubeResultEntry, File file) {
        if (youtubeResultEntry == null || youtubeResultEntry.getUrl() == null) {
            return;
        }
        YoutubeVideoDownloader youtubeVideoDownloader = new YoutubeVideoDownloader(youtubeResultEntry, file);
        youtubeVideoDownloader.execute();
    }

    protected void playVideoAtYoutube() {
        YoutubeResultEntry youtubeResultEntry;
        int n = this.youtubeResultTable.getSelectedRow();
        if (n != -1 && (youtubeResultEntry = ((YoutubeResultTableModel)this.youtubeResultTable.getModel()).getEntry(n)).getUrl() != null) {
            DesktopUtils.openURL(youtubeResultEntry.getUrl());
            if (PlayerHandler.getInstance().isEnginePlaying()) {
                PlayerHandler.getInstance().playCurrentAudioObject(true);
            }
        }
    }

    protected void searchMoreResultsInYoutube() {
        String string = YoutubeService.getInstance().getSearchForAudioObject(ContextHandler.getInstance().getCurrentAudioObject());
        if (string.length() > 0) {
            List<YoutubeResultEntry> list = YoutubeService.getInstance().searchInYoutube(string, this.youtubeResultTable.getRowCount() + 1);
            ((YoutubeResultTableModel)this.youtubeResultTable.getModel()).addEntries(list);
        }
    }

    protected void openYoutube() {
        DesktopUtils.openSearch(SearchFactory.getSearchForName("YouTube"), YoutubeService.getInstance().getSearchForAudioObject(ContextHandler.getInstance().getCurrentAudioObject()));
    }

    private static class YoutubeResultsTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private YoutubeResultsTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return YoutubeContent.getPanelForTableRenderer(((YoutubeResultEntry)object).getImage(), StringUtils.getString("<html>", ((YoutubeResultEntry)object).getName(), "<br>(", ((YoutubeResultEntry)object).getDuration(), ")</html>"), component.getBackground(), 75, 75);
        }
    }

    private final class YoutubeResultsTableMouseAdapter
    extends MouseAdapter {
        private final JPopupMenu youtubeTableMenu;

        private YoutubeResultsTableMouseAdapter(JPopupMenu jPopupMenu) {
            this.youtubeTableMenu = jPopupMenu;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
            if (mouseEvent.getButton() == 1) {
                YoutubeContent.this.playVideoAtYoutube();
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            YoutubeContent.this.youtubeResultTable.getSelectionModel().setSelectionInterval(YoutubeContent.this.youtubeResultTable.rowAtPoint(mouseEvent.getPoint()), YoutubeContent.this.youtubeResultTable.rowAtPoint(mouseEvent.getPoint()));
            this.youtubeTableMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

