/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.similar;

import java.awt.Image;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationDataSource;
import net.sourceforge.atunes.kernel.modules.context.SimilarArtistsInfo;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ImageUtils;

public class SimilarArtistsDataSource
implements ContextInformationDataSource {
    public static final String INPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String OUTPUT_ARTISTS = "ARTISTS";

    @Override
    public Map<String, ?> getData(Map<String, ?> map) {
        HashMap<String, SimilarArtistsInfo> hashMap = new HashMap<String, SimilarArtistsInfo>();
        if (map.containsKey(INPUT_AUDIO_OBJECT)) {
            hashMap.put(OUTPUT_ARTISTS, this.getSimilarArtists((AudioObject)map.get(INPUT_AUDIO_OBJECT)));
        }
        return hashMap;
    }

    private SimilarArtistsInfo getSimilarArtists(AudioObject audioObject) {
        if (!Artist.isUnknownArtist(audioObject.getArtist())) {
            SimilarArtistsInfo similarArtistsInfo = LastFmService.getInstance().getSimilarArtists(audioObject.getArtist());
            if (similarArtistsInfo != null) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Artist serializable : RepositoryHandler.getInstance().getArtists()) {
                    hashSet.add(serializable.getName().toUpperCase());
                }
                for (int i = 0; i < similarArtistsInfo.getArtists().size(); ++i) {
                    ArtistInfo artistInfo = similarArtistsInfo.getArtists().get(i);
                    Image image = LastFmService.getInstance().getImage(artistInfo);
                    artistInfo.setImage(ImageUtils.scaleImageBicubic(image, 75, 75));
                    artistInfo.setAvailable(hashSet.contains(artistInfo.getName().toUpperCase()));
                }
            }
            return similarArtistsInfo;
        }
        return null;
    }
}

