/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.audioobject;

import java.awt.Image;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationDataSource;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.AudioFileStats;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class AudioObjectBasicInfoDataSource
implements ContextInformationDataSource {
    public static final String INPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String OUTPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String OUTPUT_IMAGE = "IMAGE";
    public static final String OUTPUT_TITLE = "TITLE";
    public static final String OUTPUT_ARTIST = "ARTIST";
    public static final String OUTPUT_LASTPLAYDATE = "LAST_PLAY_DATE";

    @Override
    public Map<String, ?> getData(Map<String, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map.containsKey("AUDIO_OBJECT")) {
            AudioObject audioObject = (AudioObject)map.get("AUDIO_OBJECT");
            hashMap.put("AUDIO_OBJECT", audioObject);
            hashMap.put(OUTPUT_IMAGE, this.getImage(audioObject));
            if (audioObject instanceof AudioFile) {
                hashMap.put(OUTPUT_TITLE, audioObject.getTitleOrFileName());
                hashMap.put(OUTPUT_ARTIST, audioObject.getArtist());
                hashMap.put(OUTPUT_LASTPLAYDATE, this.getLastPlayDate(audioObject));
            } else if (audioObject instanceof Radio) {
                hashMap.put(OUTPUT_TITLE, ((Radio)audioObject).getName());
                hashMap.put(OUTPUT_ARTIST, ((Radio)audioObject).getUrl());
            } else if (audioObject instanceof PodcastFeedEntry) {
                hashMap.put(OUTPUT_TITLE, ((PodcastFeedEntry)audioObject).getTitle());
            }
        }
        return hashMap;
    }

    private ImageIcon getImage(AudioObject audioObject) {
        if (audioObject instanceof AudioFile) {
            Image image;
            ImageIcon imageIcon = audioObject.getImage(Constants.ALBUM_IMAGE_SIZE);
            if (imageIcon == null && (image = LastFmService.getInstance().getAlbumImage(audioObject.getArtist(), audioObject.getAlbum())) != null) {
                imageIcon = ImageUtils.resize(new ImageIcon(image), Constants.ALBUM_IMAGE_SIZE.getSize(), Constants.ALBUM_IMAGE_SIZE.getSize());
            }
            return imageIcon;
        }
        if (audioObject instanceof Radio) {
            return Images.getImage("radio.png");
        }
        if (audioObject instanceof PodcastFeedEntry) {
            return Images.getImage("rss.png");
        }
        return null;
    }

    private String getLastPlayDate(AudioObject audioObject) {
        AudioFileStats audioFileStats = StatisticsHandler.getInstance().getAudioFileStatistics((AudioFile)audioObject);
        if (audioFileStats == null) {
            return I18nUtils.getString("SONG_NEVER_PLAYED");
        }
        Date date = audioFileStats.getLastPlayed();
        if (date == null) {
            return I18nUtils.getString("SONG_NEVER_PLAYED");
        }
        return StringUtils.getString("<html>", I18nUtils.getString("LAST_DATE_PLAYED"), ":<br/><center> ", DateUtils.toString(date), "<center></html>");
    }
}

