/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.artist;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.AlbumListInfo;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationDataSource;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;

public class ArtistInfoDataSource
implements ContextInformationDataSource {
    public static final String INPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String INPUT_ALBUMS = "ALBUMS";
    public static final String INPUT_BOOLEAN_IMAGE = "IMAGE";
    public static final String OUTPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String OUTPUT_IMAGE = "IMAGE";
    public static final String OUTPUT_ARTIST_NAME = "ARTIST_NAME";
    public static final String OUTPUT_ARTIST_URL = "ARTIST_URL";
    public static final String OUTPUT_WIKI_TEXT = "WIKI_TEXT";
    public static final String OUTPUT_WIKI_URL = "WIKI_URL";
    public static final String OUTPUT_ALBUMS = "ALBUMS";

    @Override
    public Map<String, ?> getData(Map<String, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map.containsKey("AUDIO_OBJECT")) {
            AudioObject audioObject = (AudioObject)map.get("AUDIO_OBJECT");
            hashMap.put("AUDIO_OBJECT", audioObject);
            if (!map.containsKey("ALBUMS")) {
                hashMap.put(OUTPUT_WIKI_TEXT, this.getWikiText(audioObject));
                hashMap.put(OUTPUT_WIKI_URL, this.getWikiUrl(audioObject));
                AlbumListInfo albumListInfo = this.getAlbumList(audioObject);
                if (albumListInfo != null && !albumListInfo.getAlbums().isEmpty()) {
                    hashMap.put(OUTPUT_ARTIST_NAME, albumListInfo.getAlbums().get(0).getArtist());
                    hashMap.put(OUTPUT_ARTIST_URL, albumListInfo.getAlbums().get(0).getArtistUrl());
                }
                hashMap.put("IMAGE", this.getArtistImage(audioObject));
            } else {
                AlbumListInfo albumListInfo = this.getAlbumList(audioObject);
                if (albumListInfo != null && !albumListInfo.getAlbums().isEmpty()) {
                    for (AlbumInfo albumInfo : albumListInfo.getAlbums()) {
                        albumInfo.setCover(ImageUtils.scaleImageBicubic(this.getAlbumImage(albumInfo), 75, 75));
                    }
                    hashMap.put("ALBUMS", albumListInfo.getAlbums());
                }
            }
        }
        return hashMap;
    }

    private String getWikiText(AudioObject audioObject) {
        if (!audioObject.getArtist().equals(I18nUtils.getString("UNKNOWN_ARTIST"))) {
            return LastFmService.getInstance().getWikiText(audioObject.getArtist());
        }
        return null;
    }

    private String getWikiUrl(AudioObject audioObject) {
        if (!audioObject.getArtist().equals(I18nUtils.getString("UNKNOWN_ARTIST"))) {
            return LastFmService.getInstance().getWikiURL(audioObject.getArtist());
        }
        return null;
    }

    private AlbumListInfo getAlbumList(AudioObject audioObject) {
        if (!audioObject.getArtist().equals(I18nUtils.getString("UNKNOWN_ARTIST"))) {
            return LastFmService.getInstance().getAlbumList(audioObject.getArtist(), ApplicationState.getInstance().isHideVariousArtistsAlbums(), ApplicationState.getInstance().getMinimumSongNumberPerAlbum());
        }
        return null;
    }

    private Image getArtistImage(AudioObject audioObject) {
        return LastFmService.getInstance().getImage(audioObject.getArtist());
    }

    private Image getAlbumImage(AlbumInfo albumInfo) {
        return LastFmService.getInstance().getImage(albumInfo);
    }
}

