/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.artist;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanel;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistAlbumsContent;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistAlbumsFlowContent;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistBasicInfoContent;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class ArtistContextPanel
extends AbstractContextPanel {
    private static final long serialVersionUID = -7910261492394049289L;
    private List<AbstractContextPanelContent> contents;

    @Override
    protected ImageIcon getContextPanelIcon(AudioObject audioObject) {
        return Images.getImage("artist.png");
    }

    @Override
    public String getContextPanelName() {
        return "ARTIST";
    }

    @Override
    protected String getContextPanelTitle(AudioObject audioObject) {
        return I18nUtils.getString("ARTIST");
    }

    @Override
    protected List<AbstractContextPanelContent> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<AbstractContextPanelContent>();
            this.contents.add(new ArtistBasicInfoContent());
            this.contents.add(ApplicationState.getInstance().isShowContextAlbumsInGrid() ? new ArtistAlbumsFlowContent() : new ArtistAlbumsContent());
        }
        return this.contents;
    }

    @Override
    protected boolean isPanelEnabledForAudioObject(AudioObject audioObject) {
        if (Artist.isUnknownArtist(audioObject.getArtist())) {
            return false;
        }
        return audioObject instanceof AudioFile || audioObject instanceof Radio && ((Radio)audioObject).isSongInfoAvailable();
    }
}

