/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.album;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanel;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.album.AlbumBasicInfoContent;
import net.sourceforge.atunes.kernel.modules.context.album.AlbumTracksContent;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class AlbumContextPanel
extends AbstractContextPanel {
    private static final long serialVersionUID = -7910261492394049289L;
    private List<AbstractContextPanelContent> contents;

    @Override
    protected ImageIcon getContextPanelIcon(AudioObject audioObject) {
        return Images.getImage("album.png");
    }

    @Override
    public String getContextPanelName() {
        return "ALBUM";
    }

    @Override
    protected String getContextPanelTitle(AudioObject audioObject) {
        return I18nUtils.getString("ALBUM");
    }

    @Override
    protected List<AbstractContextPanelContent> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<AbstractContextPanelContent>();
            this.contents.add(new AlbumBasicInfoContent());
            this.contents.add(new AlbumTracksContent());
        }
        return this.contents;
    }

    @Override
    protected boolean isPanelEnabledForAudioObject(AudioObject audioObject) {
        if (Artist.isUnknownArtist(audioObject.getArtist()) || Album.isUnknownAlbum(audioObject.getAlbum())) {
            return false;
        }
        return audioObject instanceof AudioFile || audioObject instanceof Radio && ((Radio)audioObject).isSongInfoAvailable();
    }
}

