/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.album;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.views.controls.UrlLabel;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.album.AlbumInfoDataSource;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public class AlbumBasicInfoContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = -5538266144953409867L;
    private JLabel albumCoverLabel;
    private UrlLabel albumLabel;
    private UrlLabel artistLabel;
    private UrlLabel yearLabel;

    public AlbumBasicInfoContent() {
        super(new AlbumInfoDataSource());
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("INFO");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        hashMap.put("IMAGE", true);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        AudioObject audioObject = (AudioObject)map.get("AUDIO_OBJECT");
        if (map.containsKey("ALBUM")) {
            AlbumInfo albumInfo = (AlbumInfo)map.get("ALBUM");
            this.artistLabel.setText(albumInfo != null ? albumInfo.getArtist() : audioObject.getArtist(), albumInfo != null ? albumInfo.getArtistUrl() : null);
            this.artistLabel.setEnabled(albumInfo != null && albumInfo.getArtistUrl() != null);
            this.albumLabel.setText(albumInfo != null ? albumInfo.getTitle() : I18nUtils.getString("UNKNOWN_ALBUM"), albumInfo != null ? albumInfo.getUrl() : null);
            this.albumLabel.setEnabled(albumInfo != null && albumInfo.getUrl() != null);
            this.yearLabel.setText(albumInfo != null ? albumInfo.getYear() : "", albumInfo != null && albumInfo.getYear() != null ? StringUtils.getString("http://en.wikipedia.org/wiki/", albumInfo.getYear()) : null);
            Image image = (Image)map.get("IMAGE");
            if (image != null) {
                ImageIcon imageIcon = ImageUtils.resize(new ImageIcon(image), Constants.ALBUM_IMAGE_SIZE.getSize(), Constants.ALBUM_IMAGE_SIZE.getSize());
                this.albumCoverLabel.setIcon(imageIcon);
                this.albumCoverLabel.setBorder((Border)new DropShadowBorder());
            }
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.albumCoverLabel.setIcon(null);
        this.albumCoverLabel.setBorder(null);
        this.albumLabel.setText(null);
        this.artistLabel.setText(null);
        this.yearLabel.setText(null);
    }

    @Override
    protected Component getComponent() {
        this.albumCoverLabel = new JLabel();
        this.albumLabel = new UrlLabel();
        this.albumLabel.setHorizontalAlignment(0);
        this.albumLabel.setFont(Fonts.getContextInformationBigFont());
        this.artistLabel = new UrlLabel();
        this.artistLabel.setHorizontalAlignment(0);
        this.yearLabel = new UrlLabel();
        this.yearLabel.setHorizontalAlignment(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel.add((Component)this.albumCoverLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)((Object)this.albumLabel), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)((Object)this.artistLabel), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)((Object)this.yearLabel), gridBagConstraints);
        return jPanel;
    }
}

