/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.command;

import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.ApplicationArguments;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.PlayNextAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.PlayPreviousAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.ShowOSDAction;
import net.sourceforge.atunes.kernel.modules.command.Command;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;

public final class CommandHandler
extends AbstractHandler {
    private static CommandHandler instance;
    public static final String COMMAND_PREFIX = "command:";
    private Map<String, Command> commands;

    public static CommandHandler getInstance() {
        if (instance == null) {
            instance = new CommandHandler();
        }
        return instance;
    }

    private CommandHandler() {
    }

    @Override
    public void applicationStarted() {
        this.runCommands(ApplicationArguments.getSavedCommands());
    }

    public void registerCommand(Command command) {
        if (this.commands == null) {
            this.commands = new HashMap<String, Command>();
        }
        this.commands.put(command.getCommandName(), command);
    }

    public void unregisterCommand(Command command) {
        if (this.commands != null) {
            this.commands.remove(command.getCommandName());
        }
    }

    public void runCommands(String string) {
        if (this.commands != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(" ")) {
                if (!this.isValidCommand(string2)) continue;
                this.processAndRun(string2);
            }
        }
    }

    public boolean isValidCommand(String string) {
        return this.isCommand(string) && this.commands.containsKey(string.replaceFirst(COMMAND_PREFIX, ""));
    }

    public boolean isCommand(String string) {
        return string.startsWith(COMMAND_PREFIX);
    }

    public void processAndRun(String string) {
        Command command = this.commands.get(string.replaceFirst(COMMAND_PREFIX, ""));
        if (command != null) {
            SwingUtilities.invokeLater(new RunCommandRunnable(command));
        }
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
        this.initActions();
    }

    private void initActions() {
        Actions.getAction(PlayNextAudioObjectAction.class);
        Actions.getAction(PlayPreviousAudioObjectAction.class);
        Actions.getAction(ShowOSDAction.class);
    }

    private static class RunCommandRunnable
    implements Runnable {
        private Command command;

        public RunCommandRunnable(Command command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.command.runCommand();
        }
    }
}

