/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class BitrateColumn
extends AbstractColumn {
    private static final long serialVersionUID = 7541146903350085592L;

    public BitrateColumn() {
        super("BITRATE", String.class);
        this.setWidth(100);
        this.setVisible(false);
        this.setAlignment(0);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        return Long.valueOf(audioObject.getBitrate()).compareTo(audioObject2.getBitrate());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject.getBitrate() > 0L) {
            return StringUtils.getString(Long.toString(audioObject.getBitrate()), " Kbps");
        }
        return "";
    }
}

