/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.encoders;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class Mp4Encoder
implements Encoder {
    public static final String FORMAT_NAME = "FAAC_MP4";
    public static final String OGGENC = "faac";
    public static final String OUTPUT = "-o";
    public static final String WRAP = "-w";
    public static final String TITLE = "--title";
    public static final String ARTIST = "--artist";
    public static final String ALBUM = "--album";
    public static final String QUALITY = "-q";
    public static final String VERSION = "--help";
    static final String[] MP4_QUALITY = new String[]{"50", "100", "150", "200", "250", "300", "350", "400", "450", "500"};
    static final String DEFAULT_MP4_QUALITY = "200";
    private Logger logger;
    private Process p;
    private ProgressListener listener;
    private String albumArtist;
    private String album;
    private int year;
    private String genre;
    private String quality;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testTool() {
        boolean bl;
        int n;
        BufferedReader bufferedReader = null;
        try {
            Process process = SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new ProcessBuilder(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, OGGENC)).start() : new ProcessBuilder(OGGENC, VERSION).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (bufferedReader.readLine() != null) {
            }
            n = process.waitFor();
            if (n != 1) {
                boolean bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (Exception exception) {
            n = 0;
            return n != 0;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(File file, File file2, String string, int n, String string2, String string3) {
        boolean bl;
        this.getLogger().info("FAAC ENCODER", StringUtils.getString("Mp4 encoding process started... ", file.getName(), " -> ", file2.getName()));
        BufferedReader bufferedReader = null;
        try {
            int n2;
            int n3;
            int n4;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, OGGENC));
            } else {
                arrayList.add(OGGENC);
            }
            arrayList.add(OUTPUT);
            arrayList.add(file2.getAbsolutePath());
            arrayList.add(QUALITY);
            arrayList.add(this.quality);
            arrayList.add(WRAP);
            arrayList.add(file.getAbsolutePath());
            this.p = new ProcessBuilder(arrayList).start();
            bufferedReader = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            String string4 = null;
            int n5 = -1;
            while ((string4 = bufferedReader.readLine()) != null) {
                if (this.listener == null) continue;
                if (string4.matches(".*(...%).*")) {
                    n4 = string4.indexOf(37);
                    n3 = Integer.parseInt(string4.substring(string4.indexOf(40) + 1, n4).trim());
                    if (n3 == n5) continue;
                    n2 = n5 = n3;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Mp4Encoder.this.listener.notifyProgress(n2);
                        }
                    });
                    continue;
                }
                if (!string4.startsWith("Done")) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Mp4Encoder.this.listener.notifyProgress(100);
                    }
                });
            }
            n4 = this.p.waitFor();
            if (n4 != 0) {
                this.getLogger().error("FAAC ENCODER", StringUtils.getString("Process returned code ", n4));
                n3 = 0;
                ClosingUtils.close(bufferedReader);
                return n3 != 0;
            }
            try {
                AudioFile audioFile = new AudioFile(file2);
                DefaultTag defaultTag = new DefaultTag();
                defaultTag.setAlbum(this.album);
                defaultTag.setAlbumArtist(this.albumArtist);
                defaultTag.setArtist(string2);
                defaultTag.setComposer(string3);
                defaultTag.setYear(this.year);
                defaultTag.setGenre(this.genre);
                defaultTag.setTitle(string);
                defaultTag.setTrackNumber(n);
                TagModifier.setInfo(audioFile, defaultTag);
            }
            catch (Exception exception) {
                this.getLogger().error("FAAC ENCODER", StringUtils.getString("Jaudiotagger: Process execution caused exception ", exception));
                n2 = 0;
                ClosingUtils.close(bufferedReader);
                return n2 != 0;
            }
            this.getLogger().info("FAAC ENCODER", "Encoded ok!!");
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (Exception exception) {
            this.getLogger().error("FAAC ENCODER", StringUtils.getString("Process execution caused exception ", exception));
            boolean bl2 = false;
            return bl2;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    @Override
    public String getExtensionOfEncodedFiles() {
        return "m4a";
    }

    public String getGenre() {
        return this.genre;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public void setAlbum(String string) {
        this.album = string;
    }

    public void setAlbumArtist(String string) {
        this.albumArtist = string;
    }

    @Override
    public void setArtist(String string) {
        this.albumArtist = string;
    }

    @Override
    public void setGenre(String string) {
        this.genre = string;
    }

    @Override
    public void setListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    @Override
    public void setQuality(String string) {
        this.quality = string;
    }

    @Override
    public void setYear(int n) {
        this.year = n;
    }

    @Override
    public void stop() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    @Override
    public String[] getAvailableQualities() {
        return MP4_QUALITY;
    }

    @Override
    public String getDefaultQuality() {
        return DEFAULT_MP4_QUALITY;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

