/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.searchResults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import net.sourceforge.atunes.gui.model.SearchResultColumnModel;
import net.sourceforge.atunes.gui.renderers.ColumnRenderers;
import net.sourceforge.atunes.gui.views.controls.ColumnSetPopupMenu;
import net.sourceforge.atunes.gui.views.controls.ColumnSetRowSorter;
import net.sourceforge.atunes.gui.views.dialogs.SearchResultsDialog;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.controllers.searchResults.SearchResultsListener;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.SearchResultsColumnSet;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.AudioObjectComparator;
import net.sourceforge.atunes.kernel.modules.search.SearchResultTableModel;
import net.sourceforge.atunes.kernel.modules.search.SearchableObject;
import net.sourceforge.atunes.model.AudioObject;

public final class SearchResultsController
extends AbstractSimpleController<SearchResultsDialog> {
    private List<AudioObject> results;

    public SearchResultsController(SearchResultsDialog searchResultsDialog) {
        super(searchResultsDialog);
        this.addBindings();
    }

    public void showSearchResults(SearchableObject searchableObject, List<AudioObject> list) {
        this.results = list;
        SearchResultTableModel searchResultTableModel = (SearchResultTableModel)((SearchResultsDialog)this.getComponentControlled()).getSearchResultsTable().getModel();
        AbstractColumn abstractColumn = SearchResultsColumnSet.getInstance().getSortedColumn();
        if (abstractColumn != null) {
            Collections.sort(list, abstractColumn.getComparator(false));
        } else {
            AudioObjectComparator.sort(list);
        }
        searchResultTableModel.setResults(list);
        searchResultTableModel.refresh(0);
        ((SearchResultsDialog)this.getComponentControlled()).setVisible(true);
    }

    @Override
    protected void addBindings() {
        JTable jTable = ((SearchResultsDialog)this.getComponentControlled()).getSearchResultsTable();
        SearchResultTableModel searchResultTableModel = new SearchResultTableModel();
        jTable.setModel(searchResultTableModel);
        SearchResultColumnModel searchResultColumnModel = new SearchResultColumnModel(jTable);
        jTable.setColumnModel(searchResultColumnModel);
        new ColumnSetRowSorter(jTable, searchResultTableModel, searchResultColumnModel);
        new ColumnSetPopupMenu(((SearchResultsDialog)this.getComponentControlled()).getSearchResultsTable(), searchResultColumnModel);
        ColumnRenderers.addRenderers(((SearchResultsDialog)this.getComponentControlled()).getSearchResultsTable(), searchResultColumnModel);
        SearchResultsListener searchResultsListener = new SearchResultsListener(this, (SearchResultsDialog)this.getComponentControlled());
        ((SearchResultsDialog)this.getComponentControlled()).getShowElementInfo().addActionListener(searchResultsListener);
        ((SearchResultsDialog)this.getComponentControlled()).getAddToCurrentPlayList().addActionListener(searchResultsListener);
        ((SearchResultsDialog)this.getComponentControlled()).getAddToNewPlayList().addActionListener(searchResultsListener);
    }

    protected void showInfo() {
        List<AudioObject> list = this.getSelectedResults();
        if (list == null) {
            return;
        }
        GuiHandler.getInstance().showPropertiesDialog(list.get(0));
    }

    protected void addToPlayList() {
        List<AudioObject> list = this.getSelectedResults();
        if (list == null) {
            return;
        }
        PlayListHandler.getInstance().addToPlayList(list);
    }

    protected void addToNewPlayList() {
        List<AudioObject> list = this.getSelectedResults();
        if (list == null) {
            return;
        }
        PlayListHandler.getInstance().newPlayList(list);
    }

    private List<AudioObject> getSelectedResults() {
        int[] nArray = ((SearchResultsDialog)this.getComponentControlled()).getSearchResultsTable().getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        JTable jTable = ((SearchResultsDialog)this.getComponentControlled()).getSearchResultsTable();
        for (int n : nArray) {
            arrayList.add(this.results.get(jTable.convertRowIndexToModel(n)));
        }
        return arrayList;
    }

    @Override
    protected void addStateBindings() {
    }

    @Override
    protected void notifyReload() {
    }
}

