/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.radioBrowser;

import java.awt.event.MouseListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.model.RadioBrowserTreeTableModel;
import net.sourceforge.atunes.gui.views.dialogs.RadioBrowserDialog;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.controllers.radioBrowser.RadioBrowserDialogListener;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import org.jdesktop.swingx.treetable.TreeTableModel;

public final class RadioBrowserDialogController
extends AbstractSimpleController<RadioBrowserDialog> {
    public RadioBrowserDialogController(RadioBrowserDialog radioBrowserDialog) {
        super(radioBrowserDialog);
        this.addBindings();
        this.addStateBindings();
    }

    public void showRadioBrowser() {
        this.retrieveData();
        ((RadioBrowserDialog)this.getComponentControlled()).setVisible(true);
    }

    public void retrieveData() {
        new RetrieveDataSwingWorker().execute();
    }

    @Override
    protected void addBindings() {
        RadioBrowserDialogListener radioBrowserDialogListener = new RadioBrowserDialogListener((RadioBrowserDialog)this.getComponentControlled());
        ((RadioBrowserDialog)this.getComponentControlled()).getTreeTable().addMouseListener((MouseListener)radioBrowserDialogListener);
    }

    @Override
    protected void addStateBindings() {
    }

    @Override
    protected void notifyReload() {
    }

    private final class RetrieveDataSwingWorker
    extends SwingWorker<List<Radio>, Void> {
        private RetrieveDataSwingWorker() {
        }

        @Override
        protected List<Radio> doInBackground() throws Exception {
            return RadioHandler.getInstance().retrieveRadiosForBrowser();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                ((RadioBrowserDialog)RadioBrowserDialogController.this.getComponentControlled()).getTreeTable().setTreeTableModel((TreeTableModel)new RadioBrowserTreeTableModel(list));
            }
            catch (InterruptedException interruptedException) {
                RadioBrowserDialogController.this.getLogger().error("CONTROLLER  ", interruptedException);
            }
            catch (ExecutionException executionException) {
                RadioBrowserDialogController.this.getLogger().error("CONTROLLER  ", executionException);
            }
        }
    }
}

