/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.osd;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import net.sourceforge.atunes.gui.WindowFader;
import net.sourceforge.atunes.gui.views.dialogs.OSDDialog;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.controllers.osd.OSDDialogMouseListener;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.utils.GuiUtils;

public final class OSDDialogController
extends AbstractSimpleController<OSDDialog> {
    private WindowFader windowFader;
    private Point location;
    private Timer timer;

    public OSDDialogController(OSDDialog oSDDialog) {
        super(oSDDialog);
        this.addBindings();
        this.windowFader = new WindowFader(oSDDialog, 50);
    }

    @Override
    protected void addBindings() {
        OSDDialogMouseListener oSDDialogMouseListener = new OSDDialogMouseListener((OSDDialog)this.getComponentControlled(), this);
        ((OSDDialog)this.getComponentControlled()).addMouseListener(oSDDialogMouseListener);
    }

    @Override
    protected void addStateBindings() {
    }

    public void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.windowFader.clear();
    }

    @Override
    protected void notifyReload() {
    }

    public void showOSD(AudioObject audioObject) {
        if (audioObject == null || GuiHandler.getInstance().getFullScreenWindow().isVisible()) {
            return;
        }
        this.stopAnimation();
        this.windowFader = new WindowFader((Window)this.getComponentControlled(), 50);
        int n = 0;
        n = ApplicationState.getInstance().getOsdHorizontalAlignment() == 0 ? Toolkit.getDefaultToolkit().getScreenSize().width / 2 - ApplicationState.getInstance().getOsdWidth() / 2 : (ApplicationState.getInstance().getOsdHorizontalAlignment() == 2 ? 50 : Toolkit.getDefaultToolkit().getScreenSize().width - ApplicationState.getInstance().getOsdWidth() - 50);
        n = Math.max(n, 0);
        int n2 = 0;
        n2 = ApplicationState.getInstance().getOsdVerticalAlignment() == 0 ? Toolkit.getDefaultToolkit().getScreenSize().height / 2 - ((OSDDialog)this.getComponentControlled()).getHeight() / 2 : (ApplicationState.getInstance().getOsdVerticalAlignment() == 1 ? 20 : Toolkit.getDefaultToolkit().getScreenSize().height - 20 - ((OSDDialog)this.getComponentControlled()).getHeight());
        this.location = new Point(n, n2);
        ((OSDDialog)this.getComponentControlled()).setShadowBorder(true);
        ImageIcon imageIcon = audioObject.getImage(ImageSize.SIZE_MAX);
        if (imageIcon == null) {
            imageIcon = audioObject.getGenericImage(GenericImageSize.MEDIUM);
            ((OSDDialog)this.getComponentControlled()).setShadowBorder(false);
        }
        ((OSDDialog)this.getComponentControlled()).setImage(imageIcon);
        ((OSDDialog)this.getComponentControlled()).setLine1(audioObject.getTitleOrFileName());
        ((OSDDialog)this.getComponentControlled()).setLine2(audioObject.getAlbum());
        ((OSDDialog)this.getComponentControlled()).setLine3(audioObject.getArtist());
        ((OSDDialog)this.getComponentControlled()).setLocation(this.location);
        GuiUtils.setWindowOpacity((Window)this.getComponentControlled(), 0.0f);
        ((OSDDialog)this.getComponentControlled()).setRoundedBorders(true);
        ((OSDDialog)this.getComponentControlled()).setVisible(true);
        ((OSDDialog)this.getComponentControlled()).repaint();
        this.windowFader.fadeIn();
        this.timer = new Timer(ApplicationState.getInstance().getOsdDuration() * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OSDDialogController.this.windowFader.fadeOut();
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }
}

