/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.navigation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;

public final class NavigationTreeMouseListener
extends MouseAdapter {
    private NavigationController controller;

    public NavigationTreeMouseListener(NavigationController navigationController) {
        this.controller = navigationController;
    }

    private boolean isNewRowSelection(JTree jTree, MouseEvent mouseEvent) {
        int[] nArray = jTree.getSelectionRows();
        if (nArray == null) {
            return false;
        }
        int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        boolean bl = false;
        for (int i = 0; !bl && i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
        }
        return !bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        AbstractNavigationView abstractNavigationView = NavigationHandler.getInstance().getCurrentView();
        this.controller.setPopupMenuCaller(abstractNavigationView.getTree());
        if (mouseEvent.getButton() == 3) {
            int n = abstractNavigationView.getTree().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (this.isNewRowSelection(abstractNavigationView.getTree(), mouseEvent) && n != -1) {
                abstractNavigationView.getTree().setSelectionRow(n);
            }
            abstractNavigationView.updateTreePopupMenuWithTreeSelection(mouseEvent);
            abstractNavigationView.getTreePopupMenu().show(abstractNavigationView.getTree(), mouseEvent.getX(), mouseEvent.getY());
        } else {
            int n = abstractNavigationView.getTree().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = abstractNavigationView.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && mouseEvent.getClickCount() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                List<AudioObject> list = this.controller.getAudioObjectsForTreeNode(abstractNavigationView.getClass(), defaultMutableTreeNode);
                PlayListHandler.getInstance().addToPlayList(list);
            }
        }
        this.controller.getNavigationTablePanel().getNavigationTable().getSelectionModel().clearSelection();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!ApplicationState.getInstance().isShowExtendedTooltip()) {
            return;
        }
        this.controller.setCurrentExtendedToolTipContent(null);
        this.controller.getExtendedToolTip().setVisible(false);
        this.controller.getToolTipTimer().stop();
    }
}

