/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.editTitlesDialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.utils.I18nUtils;

public final class EditTitlesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4440078678648669115L;
    private List<AudioFile> files;
    private Map<AudioFile, String> newValues;
    private List<TableModelListener> listeners;

    public EditTitlesTableModel(List<AudioFile> list) {
        this.files = list;
        this.newValues = new HashMap<AudioFile, String>();
        this.listeners = new ArrayList<TableModelListener>();
    }

    public void addListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nUtils.getString("FILE");
        }
        return I18nUtils.getString("TITLE");
    }

    public Map<AudioFile, String> getNewValues() {
        return this.newValues;
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public String getValueAt(int n, int n2) {
        AudioFile audioFile = this.files.get(n);
        if (n2 == 0) {
            return audioFile.getFile().getName();
        }
        if (this.newValues.containsKey(audioFile)) {
            return this.newValues.get(audioFile);
        }
        return audioFile.getTitle();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    public void setTitles(List<String> list) {
        for (int i = 0; i < this.files.size(); ++i) {
            this.newValues.put(this.files.get(i), list.get(i));
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this, -1, 0);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tableChanged(tableModelEvent);
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.newValues.put(this.files.get(n), (String)object);
        this.fireTableCellUpdated(n, n2);
    }
}

