/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.editTitlesDialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.gui.views.dialogs.EditTitlesDialog;
import net.sourceforge.atunes.kernel.controllers.editTitlesDialog.EditTitlesDialogActionListener;
import net.sourceforge.atunes.kernel.controllers.editTitlesDialog.EditTitlesTableModel;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.EditTitlesProcess;

public final class EditTitlesDialogController
extends AbstractSimpleController<EditTitlesDialog> {
    private List<AudioFile> filesToEdit;
    private Album album;
    private EditTitlesTableModel model;

    public EditTitlesDialogController(EditTitlesDialog editTitlesDialog) {
        super(editTitlesDialog);
        this.addBindings();
    }

    @Override
    protected void addBindings() {
        EditTitlesDialogActionListener editTitlesDialogActionListener = new EditTitlesDialogActionListener((EditTitlesDialog)this.getComponentControlled(), this);
        ((EditTitlesDialog)this.getComponentControlled()).getRetrieveTitles().addActionListener(editTitlesDialogActionListener);
        ((EditTitlesDialog)this.getComponentControlled()).getOkButton().addActionListener(editTitlesDialogActionListener);
        ((EditTitlesDialog)this.getComponentControlled()).getCancelButton().addActionListener(editTitlesDialogActionListener);
    }

    @Override
    protected void addStateBindings() {
    }

    protected void editFiles() {
        Map<AudioFile, String> map = ((EditTitlesTableModel)((EditTitlesDialog)this.getComponentControlled()).getTable().getModel()).getNewValues();
        EditTitlesProcess editTitlesProcess = new EditTitlesProcess(new ArrayList<AudioFile>(map.keySet()));
        editTitlesProcess.setFilesAndTitles(map);
        editTitlesProcess.execute();
    }

    public void editFiles(Album album) {
        this.getLogger().debugMethodCall("CONTROLLER  ", album.getName());
        this.album = album;
        this.filesToEdit = album.getAudioFiles();
        Collections.sort(this.filesToEdit);
        this.model = new EditTitlesTableModel(this.filesToEdit);
        ((EditTitlesDialog)this.getComponentControlled()).getTable().setModel(this.model);
        ((EditTitlesDialog)this.getComponentControlled()).setVisible(true);
    }

    protected Album getAlbum() {
        return this.album;
    }

    @Override
    protected void notifyReload() {
    }

    protected void setTitles(List<String> list) {
        this.model.setTitles(list);
        ((EditTitlesDialog)this.getComponentControlled()).getTable().repaint();
    }
}

