/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.editTagDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.gui.views.dialogs.EditTagDialog;
import net.sourceforge.atunes.kernel.controllers.editTagDialog.EditTagDialogController;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.ImageInfo;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;

public final class EditTagDialogActionListener
implements ActionListener {
    private Logger logger;
    private EditTagDialogController controller;
    private EditTagDialog dialog;

    public EditTagDialogActionListener(EditTagDialogController editTagDialogController, EditTagDialog editTagDialog) {
        this.controller = editTagDialogController;
        this.dialog = editTagDialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.dialog.getOkButton()) {
            this.controller.editTag();
            this.controller.clear();
            this.dialog.setVisible(false);
        } else if (actionEvent.getSource() == this.dialog.getNextButton()) {
            this.controller.editTag();
            this.controller.clear();
            List<AudioObject> list = PlayListHandler.getInstance().getSelectedAudioObjects();
            AudioObject audioObject = list.get(0);
            int n = PlayListHandler.getInstance().getIndexOfAudioObject(audioObject);
            ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
            boolean bl = false;
            int n2 = PlayListHandler.getInstance().getCurrentPlayList(true).size();
            while (!bl && n2 >= n + 2) {
                PlayListHandler.getInstance().changeSelectedAudioObjectToIndex(++n);
                list.clear();
                list.add(PlayListHandler.getInstance().getSelectedAudioObjects().get(0));
                bl = AudioFile.isValidAudioFile(list.get(0).getUrl());
            }
            if (bl) {
                arrayList.add((AudioFile)list.get(0));
                this.controller.editFiles(arrayList);
            }
        } else if (actionEvent.getSource() == this.dialog.getPrevButton()) {
            this.controller.editTag();
            this.controller.clear();
            List<AudioObject> list = PlayListHandler.getInstance().getSelectedAudioObjects();
            AudioObject audioObject = list.get(0);
            int n = PlayListHandler.getInstance().getIndexOfAudioObject(audioObject);
            ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
            boolean bl = false;
            while (!bl) {
                PlayListHandler.getInstance().changeSelectedAudioObjectToIndex(--n);
                list.clear();
                list.add(PlayListHandler.getInstance().getSelectedAudioObjects().get(0));
                bl = AudioFile.isValidAudioFile(list.get(0).getUrl());
                if (n != -1) continue;
                bl = false;
                break;
            }
            if (bl) {
                arrayList.add((AudioFile)list.get(0));
                this.controller.editFiles(arrayList);
            }
        } else if (actionEvent.getSource() == this.dialog.getCancelButton()) {
            this.dialog.setVisible(false);
            this.controller.clear();
        } else if (actionEvent.getSource() == this.dialog.getCoverButton()) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new ImagesFileFiler());
            jFileChooser.setCurrentDirectory(this.getCommonDirectoryForAudioFiles());
            int n = jFileChooser.showOpenDialog(this.dialog);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    BufferedImage bufferedImage2 = ImageUtils.toBufferedImage(ImageUtils.scaleImageBicubic(bufferedImage, 400, 400).getImage());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    ImageInfo imageInfo = new ImageInfo();
                    imageInfo.setInput(new FileInputStream(file));
                    ImageIO.write((RenderedImage)bufferedImage, imageInfo.getFormatName(), byteArrayOutputStream);
                    ImageIO.write((RenderedImage)bufferedImage2, imageInfo.getFormatName(), byteArrayOutputStream2);
                    this.controller.setNewCover(byteArrayOutputStream.toByteArray());
                    this.dialog.getCover().setIcon(new ImageIcon(byteArrayOutputStream2.toByteArray()));
                    this.controller.setCoverEdited(true);
                }
                catch (IOException iOException) {
                    this.controller.setNewCover(null);
                    this.controller.setCoverEdited(false);
                    this.getLogger().error("FILE READ   ", iOException);
                }
            }
        } else if (actionEvent.getSource() == this.dialog.getRemoveCoverButton()) {
            this.dialog.getCover().setIcon(null);
            this.controller.setNewCover(null);
            this.controller.setCoverEdited(true);
        }
    }

    private File getCommonDirectoryForAudioFiles() {
        List<AudioFile> list = this.controller.getAudioFilesEditing();
        if (list.size() == 1) {
            return list.get(0).getFile().getParentFile();
        }
        return null;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private static class ImagesFileFiler
    extends FileFilter {
        private ImagesFileFiler() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toUpperCase();
            return string.endsWith("JPG") || string.endsWith("JPEG") || string.endsWith("PNG");
        }

        @Override
        public String getDescription() {
            return I18nUtils.getString("IMAGES");
        }
    }
}

