/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class SetPlayListSelectionAsFavoriteArtistAction
extends AbstractAction {
    private static final long serialVersionUID = 3403777999793279297L;

    SetPlayListSelectionAsFavoriteArtistAction() {
        super(I18nUtils.getString("SET_FAVORITE_ARTIST"), Images.getImage("artistFavorite.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FavoritesHandler.getInstance().addFavoriteArtists(AudioFile.getAudioFiles(PlayListHandler.getInstance().getSelectedAudioObjects()));
    }

    @Override
    public boolean isEnabledForPlayListSelection(List<AudioObject> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (AudioObject audioObject : list) {
            if (!(audioObject instanceof Radio) && !(audioObject instanceof PodcastFeedEntry)) continue;
            return false;
        }
        return true;
    }
}

