/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.RadioNavigationView;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import net.sourceforge.atunes.utils.I18nUtils;

public class RenameRadioLabelAction
extends AbstractAction {
    private static final long serialVersionUID = -606790181321223318L;

    RenameRadioLabelAction() {
        super(I18nUtils.getString("RENAME_LABEL"), Images.getImage("editAlbum.png"));
        this.putValue("ShortDescription", I18nUtils.getString("RENAME_LABEL"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getView(RadioNavigationView.class).getTree().getSelectionPath();
        Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        if (object instanceof String) {
            String string = (String)object;
            String string2 = GuiHandler.getInstance().showInputDialog(I18nUtils.getString("RENAME_LABEL"), string, Images.getImage("radio_little.png").getImage());
            if (string2 != null) {
                List<Radio> list = RadioHandler.getInstance().getRadios(string);
                RadioHandler.getInstance().setLabel(list, string2);
                NavigationHandler.getInstance().refreshView(RadioNavigationView.class);
            }
        } else if (object instanceof Radio) {
            Radio radio = (Radio)object;
            String string = GuiHandler.getInstance().showInputDialog(I18nUtils.getString("RENAME_LABEL"), radio.getLabel(), Images.getImage("radio_little.png").getImage());
            if (string != null) {
                radio.setLabel(string);
                NavigationHandler.getInstance().refreshView(RadioNavigationView.class);
            }
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return !bl;
    }
}

