/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class RemoveOldPodcastEntryAction
extends AbstractActionOverSelectedObjects<PodcastFeedEntry> {
    private static final long serialVersionUID = -1499729879534990802L;

    RemoveOldPodcastEntryAction() {
        super(I18nUtils.getString("REMOVE_OLD_PODCAST_ENTRY"), Images.getImage("remove.png"), PodcastFeedEntry.class);
        this.putValue("ShortDescription", I18nUtils.getString("REMOVE_OLD_PODCAST_ENTRY"));
    }

    @Override
    protected void performAction(List<PodcastFeedEntry> list) {
        for (PodcastFeedEntry podcastFeedEntry : list) {
            podcastFeedEntry.getPodcastFeed().removeEntry(podcastFeedEntry);
        }
        NavigationHandler.getInstance().refreshView(PodcastNavigationView.class);
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        for (AudioObject audioObject : list) {
            if (audioObject instanceof PodcastFeedEntry && ((PodcastFeedEntry)audioObject).isOld()) continue;
            return false;
        }
        return true;
    }
}

