/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class PlayNowAction
extends AbstractAction {
    private static final long serialVersionUID = -2099290583376403144L;

    PlayNowAction() {
        super(I18nUtils.getString("PLAY_NOW"), Images.getImage("playTiny.png"));
        this.putValue("ShortDescription", I18nUtils.getString("PLAY_NOW"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getSelectedRow();
        AudioObject audioObject = ((NavigationTableModel)ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getModel()).getAudioObjectAt(n);
        PlayListHandler.getInstance().playNow(audioObject);
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return list.size() == 1;
    }
}

