/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class DownloadPodcastEntryAction
extends AbstractActionOverSelectedObjects<PodcastFeedEntry> {
    private static final long serialVersionUID = 1081237259786604605L;

    DownloadPodcastEntryAction() {
        super(I18nUtils.getString("DOWNLOAD_PODCAST_ENTRY"), Images.getImage("rss_download.png"), PodcastFeedEntry.class);
        this.putValue("ShortDescription", I18nUtils.getString("DOWNLOAD_PODCAST_ENTRY"));
        this.setEnabled(false);
    }

    @Override
    protected void performAction(List<PodcastFeedEntry> list) {
        for (PodcastFeedEntry podcastFeedEntry : list) {
            PodcastFeedHandler.getInstance().downloadPodcastFeedEntry(podcastFeedEntry);
        }
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        for (AudioObject audioObject : list) {
            if (audioObject instanceof PodcastFeedEntry && !((PodcastFeedEntry)audioObject).isDownloaded() && !PodcastFeedHandler.getInstance().isDownloading((PodcastFeedEntry)audioObject)) continue;
            return false;
        }
        return true;
    }
}

