/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.Window;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.views.dialogs.PatternInputDialog;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.pattern.AbstractPattern;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.EditTagFromFolderNamePatternProcess;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class AutoSetTagFromFolderNamePatternAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = -1253820711948217089L;

    public AutoSetTagFromFolderNamePatternAction() {
        super(StringUtils.getString(I18nUtils.getString("AUTO_SET_TAG_FROM_FOLDER_NAME_PATTERN"), "..."), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("AUTO_SET_TAG_FROM_FOLDER_NAME_PATTERN"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        PatternInputDialog patternInputDialog = new PatternInputDialog((Window)GuiHandler.getInstance().getFrame().getFrame(), false);
        patternInputDialog.show(AbstractPattern.getRecognitionPatterns(), list.get(0).getFile().getParentFile().getName());
        String string = patternInputDialog.getResult();
        if (string != null) {
            new EditTagFromFolderNamePatternProcess(list, string).execute();
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return !bl && !list.isEmpty();
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return !list.isEmpty();
    }
}

