/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.sourceforge.atunes.kernel.ApplicationFinishListener;
import net.sourceforge.atunes.kernel.ApplicationStartListener;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.cdripper.RipperHandler;
import net.sourceforge.atunes.kernel.modules.command.CommandHandler;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeyHandler;
import net.sourceforge.atunes.kernel.modules.instances.MultipleInstancesHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.notify.NotifyHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.plugins.GeneralPurposePluginsHandler;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.kernel.modules.search.SearchHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateChangeListener;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.kernel.modules.tray.SystemTrayHandler;
import net.sourceforge.atunes.kernel.modules.updates.UpdateHandler;
import net.sourceforge.atunes.misc.log.Logger;

public abstract class AbstractHandler
implements ApplicationStartListener,
ApplicationFinishListener,
ApplicationStateChangeListener {
    private static Logger logger;
    private static List<Class<? extends AbstractHandler>> handlerClasses;
    private static ExecutorService executorService;
    private static List<AbstractHandler> handlers;

    protected abstract void initHandler();

    protected Runnable getPreviousInitializationTask() {
        return null;
    }

    private static final void registerHandler(AbstractHandler abstractHandler) {
        Kernel.getInstance().addStartListener(abstractHandler);
        Kernel.getInstance().addFinishListener(abstractHandler);
        ApplicationStateHandler.getInstance().addStateChangeListener(abstractHandler);
    }

    protected static final Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    static void registerHandlers() {
        Object illegalAccessException;
        for (Class<? extends AbstractHandler> object2 : handlerClasses) {
            try {
                illegalAccessException = object2.getMethod("getInstance", new Class[0]);
                handlers.add((AbstractHandler)((Method)illegalAccessException).invoke(null, new Object[0]));
            }
            catch (SecurityException invocationTargetException) {
                AbstractHandler.getLogger().error("HANDLER     ", invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                AbstractHandler.getLogger().error("HANDLER     ", noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AbstractHandler.getLogger().error("HANDLER     ", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException2) {
                AbstractHandler.getLogger().error("HANDLER     ", illegalAccessException2);
            }
            catch (InvocationTargetException invocationTargetException) {
                AbstractHandler.getLogger().error("HANDLER     ", invocationTargetException);
                AbstractHandler.getLogger().error("HANDLER     ", invocationTargetException.getCause());
            }
        }
        for (AbstractHandler abstractHandler : handlers) {
            AbstractHandler.registerHandler(abstractHandler);
            AbstractHandler.getLogger().debug("HANDLER     ", "Registered handler: ", abstractHandler.getClass().getName());
        }
        for (AbstractHandler abstractHandler : handlers) {
            illegalAccessException = abstractHandler.getPreviousInitializationTask();
            if (illegalAccessException == null) continue;
            executorService.submit((Runnable)illegalAccessException);
        }
        executorService.shutdown();
    }

    static void initHandlers() {
        try {
            executorService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            logger.error("HANDLER     ", interruptedException);
        }
        for (AbstractHandler abstractHandler : handlers) {
            abstractHandler.initHandler();
            AbstractHandler.getLogger().debug("HANDLER     ", "Initialized handler: ", abstractHandler.getClass().getName());
        }
    }

    static {
        executorService = Executors.newFixedThreadPool(3);
        handlerClasses = new ArrayList<Class<? extends AbstractHandler>>();
        handlerClasses.add(ApplicationStateHandler.class);
        handlerClasses.add(PodcastFeedHandler.class);
        handlerClasses.add(ContextHandler.class);
        handlerClasses.add(RipperHandler.class);
        handlerClasses.add(CommandHandler.class);
        handlerClasses.add(DeviceHandler.class);
        handlerClasses.add(FavoritesHandler.class);
        handlerClasses.add(HotkeyHandler.class);
        handlerClasses.add(MultipleInstancesHandler.class);
        handlerClasses.add(NavigationHandler.class);
        handlerClasses.add(NotifyHandler.class);
        handlerClasses.add(PlayerHandler.class);
        handlerClasses.add(FilterHandler.class);
        handlerClasses.add(PlayListHandler.class);
        handlerClasses.add(PluginsHandler.class);
        handlerClasses.add(RadioHandler.class);
        handlerClasses.add(RepositoryHandler.class);
        handlerClasses.add(SearchHandler.class);
        handlerClasses.add(UpdateHandler.class);
        handlerClasses.add(GuiHandler.class);
        handlerClasses.add(StatisticsHandler.class);
        handlerClasses.add(SystemTrayHandler.class);
        handlerClasses.add(GeneralPurposePluginsHandler.class);
        handlers = new ArrayList<AbstractHandler>();
    }
}

