/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.GuiUtils;

public final class NavigationTreePanel
extends JPanel {
    private static final long serialVersionUID = -2900418193013495812L;
    private JTabbedPane tabbedPane;

    public NavigationTreePanel() {
        super(new BorderLayout(), true);
        this.addContent();
    }

    private void addContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane(ApplicationState.getInstance().isShowNavigatorTabsAtLeft() ? 2 : 1);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        this.addTabs();
        this.setNavigatorTabsText(ApplicationState.getInstance().isShowNavigatorTabsText());
        jPanel.add((Component)this.tabbedPane, "Center");
        this.add(jPanel);
        for (AbstractNavigationView abstractNavigationView : NavigationHandler.getInstance().getNavigationViews()) {
            GuiUtils.applyComponentOrientation(abstractNavigationView.getTreePopupMenu());
        }
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void addTabs() {
        this.tabbedPane.removeAll();
        for (AbstractNavigationView abstractNavigationView : NavigationHandler.getInstance().getNavigationViews()) {
            this.tabbedPane.addTab(abstractNavigationView.getTitle(), abstractNavigationView.getIcon(), abstractNavigationView.getTreeScrollPane(), abstractNavigationView.getTooltip());
        }
    }

    public void setNavigatorTabsText(boolean bl) {
        int n = 0;
        for (AbstractNavigationView abstractNavigationView : NavigationHandler.getInstance().getNavigationViews()) {
            this.tabbedPane.setTitleAt(n++, bl ? abstractNavigationView.getTitle() : null);
        }
    }

    public void updateTabs() {
        int n = this.tabbedPane.getSelectedIndex();
        this.addTabs();
        this.setNavigatorTabsText(ApplicationState.getInstance().isShowNavigatorTabsText());
        if (this.tabbedPane.getTabCount() > n) {
            this.tabbedPane.setSelectedIndex(n);
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
    }
}

