/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.UrlLabel;
import net.sourceforge.atunes.gui.views.dialogs.PluginEditorDialog;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.commonjukebox.plugins.exceptions.InvalidPluginConfigurationException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.PluginConfiguration;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;

public final class PluginsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 8611795969151425262L;
    private JTable pluginsTable = new JTable();
    private JButton pluginPreferencesButton;
    private JButton uninstallPluginButton;
    private static final int CELL_HEIGHT = 30;
    private Logger logger;
    private Map<PluginInfo, PluginConfiguration> pluginsModified;
    private Map<PluginInfo, Boolean> pluginsActivation;

    public PluginsPanel() {
        super(I18nUtils.getString("PLUGINS"));
        this.pluginsTable.setRowHeight(30);
        this.pluginsTable.setShowGrid(false);
        this.pluginsTable.setSelectionMode(0);
        this.pluginsTable.setColumnModel(new PluginsTableDefaultTableColumnModel());
        JScrollPane jScrollPane = new JScrollPane(this.pluginsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 3;
        this.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        final JLabel jLabel = new JLabel();
        jLabel.setFont(Fonts.getSmallFont());
        final JLabel jLabel2 = new JLabel();
        jLabel2.setFont(Fonts.getSmallFont());
        final JLabel jLabel3 = new JLabel();
        jLabel3.setFont(Fonts.getSmallFont());
        final JLabel jLabel4 = new JLabel();
        jLabel4.setFont(Fonts.getSmallFont());
        final JLabel jLabel5 = new JLabel();
        jLabel5.setFont(Fonts.getSmallFont());
        final UrlLabel urlLabel = new UrlLabel();
        urlLabel.setFont(Fonts.getSmallFont());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.gridy = 2;
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        gridBagConstraints2.gridy = 3;
        jPanel.add((Component)jLabel4, gridBagConstraints2);
        gridBagConstraints2.gridy = 4;
        jPanel.add((Component)jLabel5, gridBagConstraints2);
        gridBagConstraints2.gridy = 5;
        jPanel.add((Component)((Object)urlLabel), gridBagConstraints2);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        this.pluginsTable.setDefaultRenderer(PluginInfo.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new PluginsTableCellRendererCode()));
        this.pluginsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PluginsPanel.this.pluginsTable.getSelectedRow() != -1) {
                    PluginInfo pluginInfo = ((PluginsTableModel)PluginsPanel.this.pluginsTable.getModel()).getPluginAt(PluginsPanel.this.pluginsTable.getSelectedRow());
                    jLabel.setText(StringUtils.getString("<html><b>", I18nUtils.getString("NAME"), ":</b> ", pluginInfo.getName(), "</html>"));
                    jLabel2.setText(StringUtils.getString("<html><b>", I18nUtils.getString("VERSION"), ":</b> ", pluginInfo.getVersion(), "</html>"));
                    jLabel3.setText(StringUtils.getString("<html><b>", I18nUtils.getString("CLASS_NAME"), ":</b> ", pluginInfo.getClassName(), "</html>"));
                    jLabel4.setText(StringUtils.getString("<html><b>", I18nUtils.getString("LOCATION"), ":</b> ", pluginInfo.getPluginFolder().getName(), "</html>"));
                    jLabel5.setText(StringUtils.getString("<html><b>", I18nUtils.getString("AUTHOR"), ":</b> ", pluginInfo.getAuthor(), "</html>"));
                    urlLabel.setText(pluginInfo.getUrl(), pluginInfo.getUrl());
                    PluginsPanel.this.pluginPreferencesButton.setEnabled(((PluginsTableModel)PluginsPanel.this.pluginsTable.getModel()).getPluginConfigurationAt(PluginsPanel.this.pluginsTable.getSelectedRow()) != null);
                    PluginsPanel.this.uninstallPluginButton.setEnabled(PluginsPanel.this.pluginsTable.getSelectedRow() != -1);
                }
            }
        });
        this.pluginPreferencesButton = new JButton(StringUtils.getString(I18nUtils.getString("PREFERENCES"), "..."));
        this.pluginPreferencesButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.pluginPreferencesButton, gridBagConstraints);
        this.pluginPreferencesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PluginsPanel.this.pluginsTable.getSelectedRow();
                PluginInfo pluginInfo = ((PluginsTableModel)PluginsPanel.this.pluginsTable.getModel()).getPluginAt(n);
                PluginConfiguration pluginConfiguration = ((PluginsTableModel)PluginsPanel.this.pluginsTable.getModel()).getPluginConfigurationAt(n);
                PluginEditorDialog pluginEditorDialog = new PluginEditorDialog((Window)GuiHandler.getInstance().getEditPreferencesDialog(), pluginInfo, pluginConfiguration);
                pluginEditorDialog.setVisible(true);
                pluginConfiguration = pluginEditorDialog.getConfiguration();
                if (pluginConfiguration != null) {
                    try {
                        PluginsHandler.getInstance().validateConfiguration(pluginInfo, pluginConfiguration);
                        PluginsPanel.this.pluginsModified.put(pluginInfo, pluginConfiguration);
                    }
                    catch (InvalidPluginConfigurationException invalidPluginConfigurationException) {
                        GuiHandler.getInstance().showErrorDialog(StringUtils.getString(I18nUtils.getString("PLUGIN_CONFIGURATION_INVALID"), invalidPluginConfigurationException.getMessage()));
                    }
                }
            }
        });
        JButton jButton = new JButton(StringUtils.getString(I18nUtils.getString("INSTALL"), "..."));
        gridBagConstraints.gridy = 1;
        this.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new InstallNewPluginActionListener());
        this.uninstallPluginButton = new JButton(I18nUtils.getString("UNINSTALL"));
        this.uninstallPluginButton.setEnabled(false);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.uninstallPluginButton, gridBagConstraints);
        this.uninstallPluginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PluginsPanel.this.pluginsTable.getSelectedRow();
                PluginInfo pluginInfo = ((PluginsTableModel)PluginsPanel.this.pluginsTable.getModel()).getPluginAt(n);
                try {
                    Map<PluginFolder, PluginSystemException> map = PluginsHandler.getInstance().uninstallPlugin(pluginInfo);
                    if (map != null) {
                        for (PluginFolder pluginFolder : map.keySet()) {
                            GuiHandler.getInstance().showExceptionDialog(pluginFolder.getName(), I18nUtils.getString("PLUGIN_UNINSTALLATION_ERROR"), (Exception)((Object)map.get(pluginFolder)));
                        }
                    }
                    PluginsPanel.this.updatePanel(null);
                }
                catch (Exception exception) {
                    GuiHandler.getInstance().showErrorDialog(exception.getMessage());
                    PluginsPanel.this.getLogger().error("PLUGINS     ", exception);
                }
            }
        });
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        boolean bl;
        block8: {
            bl = false;
            try {
                for (PluginInfo pluginInfo : this.pluginsModified.keySet()) {
                    this.getLogger().debug("PLUGINS     ", "Writting configuration of plugin: ", pluginInfo.getName());
                    try {
                        PluginsHandler.getInstance().setConfiguration(pluginInfo, this.pluginsModified.get(pluginInfo));
                    }
                    catch (PluginSystemException pluginSystemException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(I18nUtils.getString("PLUGIN_CONFIGURATION_ERROR"));
                        stringBuilder.append(" ");
                        stringBuilder.append(pluginInfo.getName());
                        GuiHandler.getInstance().showExceptionDialog(stringBuilder.toString(), (Exception)((Object)pluginSystemException));
                    }
                    bl = bl || PluginsHandler.getInstance().pluginNeedsRestart(pluginInfo);
                }
                for (PluginInfo pluginInfo : this.pluginsActivation.keySet()) {
                    if (this.pluginsActivation.get(pluginInfo).booleanValue()) {
                        PluginsHandler.getInstance().activatePlugin(pluginInfo);
                    } else {
                        PluginsHandler.getInstance().deactivatePlugin(pluginInfo);
                    }
                    bl = bl || PluginsHandler.getInstance().pluginNeedsRestart(pluginInfo);
                }
            }
            catch (PluginSystemException pluginSystemException) {
                this.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
                if (pluginSystemException.getCause() == null) break block8;
                this.getLogger().error("PLUGINS     ", pluginSystemException.getCause());
            }
        }
        return bl;
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        List<PluginInfo> list = PluginsHandler.getInstance().getAvailablePlugins();
        this.pluginsTable.setModel(new PluginsTableModel(list));
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
        if (bl) {
            this.pluginsModified = new HashMap<PluginInfo, PluginConfiguration>();
            this.pluginsActivation = new HashMap<PluginInfo, Boolean>();
            if (!PluginsHandler.getInstance().getAvailablePlugins().isEmpty()) {
                this.pluginsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("plugin.png");
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private class PluginsTableModel
    implements TableModel {
        private List<PluginInfo> plugins;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        public PluginsTableModel(List<PluginInfo> list) {
            this.plugins = list;
            Collections.sort(this.plugins, new Comparator<PluginInfo>(){

                @Override
                public int compare(PluginInfo pluginInfo, PluginInfo pluginInfo2) {
                    return pluginInfo.getName().compareToIgnoreCase(pluginInfo2.getName());
                }
            });
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return PluginInfo.class;
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return I18nUtils.getString("ACTIVE");
                }
                case 1: {
                    return I18nUtils.getString("NAME");
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.plugins.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return PluginsPanel.this.pluginsActivation.containsKey(this.plugins.get(n)) ? ((Boolean)PluginsPanel.this.pluginsActivation.get(this.plugins.get(n))).booleanValue() : this.plugins.get(n).isActive();
                }
                case 1: {
                    return this.plugins.get(n);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (((Boolean)object).booleanValue() != this.plugins.get(n).isActive()) {
                    PluginsPanel.this.pluginsActivation.put(this.plugins.get(n), (Boolean)object);
                } else {
                    PluginsPanel.this.pluginsActivation.remove(this.plugins.get(n));
                }
            }
        }

        public PluginConfiguration getPluginConfigurationAt(int n) {
            try {
                return PluginsHandler.getInstance().getConfiguration(this.plugins.get(n));
            }
            catch (PluginSystemException pluginSystemException) {
                PluginsPanel.this.logger.error("PLUGINS     ", (Object)pluginSystemException);
                return null;
            }
        }

        public PluginInfo getPluginAt(int n) {
            return this.plugins.get(n);
        }
    }

    private static class PluginsTableDefaultTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -4128210690358582389L;

        private PluginsTableDefaultTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            super.addColumn(tableColumn);
            if (tableColumn.getHeaderValue().equals(I18nUtils.getString("ACTIVE"))) {
                tableColumn.setMinWidth(80);
                tableColumn.setMaxWidth(100);
            }
        }
    }

    private static class PluginsTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private PluginsTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component2 = component;
            ((JLabel)component2).setText(((PluginInfo)object).getName());
            if (((PluginInfo)object).getIcon() != null) {
                ((JLabel)component2).setIcon(ImageUtils.scaleImageBicubic(((PluginInfo)object).getIcon(), 25, 25));
            } else {
                ((JLabel)component2).setIcon(ImageUtils.scaleImageBicubic(Images.getImage("empty.png").getImage(), 25, 25));
            }
            return component2;
        }
    }

    private final class InstallNewPluginActionListener
    implements ActionListener {
        private InstallNewPluginActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toUpperCase().endsWith("ZIP");
                }

                @Override
                public String getDescription() {
                    return I18nUtils.getString("ZIP_FILES");
                }
            };
            jFileChooser.setFileFilter(fileFilter);
            if (jFileChooser.showOpenDialog(GuiHandler.getInstance().getFrame().getFrame()) == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    Map<PluginFolder, PluginSystemException> map = PluginsHandler.getInstance().installPlugin(file);
                    if (map != null) {
                        for (PluginFolder pluginFolder : map.keySet()) {
                            GuiHandler.getInstance().showExceptionDialog(pluginFolder.getName(), I18nUtils.getString("PLUGIN_INSTALLATION_ERROR"), (Exception)((Object)map.get(pluginFolder)));
                        }
                    }
                    PluginsPanel.this.updatePanel(null);
                }
                catch (Exception exception) {
                    GuiHandler.getInstance().showExceptionDialog(I18nUtils.getString("PLUGIN_INSTALLATION_ERROR"), exception);
                }
            }
        }
    }
}

