/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.gui.views.controls.UrlLabel;
import net.sourceforge.atunes.kernel.modules.updates.ApplicationVersion;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class UpdateDialog
extends CustomFrame {
    private static final long serialVersionUID = -778226654176158965L;

    public UpdateDialog(ApplicationVersion applicationVersion, Component component) {
        super(I18nUtils.getString("NEW_VERSION_AVAILABLE"), 400, 150, component);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = I18nUtils.getString("NEW_VERSION_AVAILABLE_TEXT");
        string = string.replace("(%VERSION%)", Constants.VERSION.toShortString());
        string = string.replace("(%NEW_VERSION%)", applicationVersion.toShortString());
        JLabel jLabel = new JLabel(Images.getImage("logo90x90.png"));
        CustomTextArea customTextArea = new CustomTextArea(string);
        customTextArea.setBorder(BorderFactory.createEmptyBorder());
        customTextArea.setEditable(false);
        customTextArea.setOpaque(false);
        customTextArea.setLineWrap(true);
        customTextArea.setWrapStyleWord(true);
        UrlLabel urlLabel = new UrlLabel(I18nUtils.getString("GO_TO_DOWNLOAD_PAGE"), applicationVersion.getDownloadURL());
        urlLabel.setHorizontalAlignment(0);
        CustomButton customButton = new CustomButton(null, I18nUtils.getString("OK"));
        customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDialog.this.dispose();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)customTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)((Object)urlLabel), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 0, 10, 0);
        jPanel.add((Component)customButton, gridBagConstraints);
        this.add(jPanel);
        this.enableDisposeActionWithEscapeKey();
        GuiUtils.applyComponentOrientation(this);
    }
}

