/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomDialog;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class SearchResultsDialog
extends CustomDialog {
    private static final long serialVersionUID = 7219089044964361102L;
    private JScrollPane tableScrollPane;
    private JTable searchResultsTable;
    private JButton showElementInfo;
    private JButton addToCurrentPlayList;
    private JButton addToNewPlayList;

    public SearchResultsDialog(JFrame jFrame) {
        super(jFrame, GuiUtils.getComponentWidthForResolution(1280, 900), 600);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(I18nUtils.getString("SEARCH_RESULTS"));
        this.add(this.getContent());
        this.enableDisposeActionWithEscapeKey();
        GuiUtils.applyComponentOrientation(this);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.searchResultsTable = new JTable();
        this.searchResultsTable.setShowGrid(false);
        this.searchResultsTable.setAutoResizeMode(0);
        this.tableScrollPane = new JScrollPane(this.searchResultsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.tableScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.getButtonsPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getButtonsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.showElementInfo = new JButton(I18nUtils.getString("INFO"), Images.getImage("info.png"));
        this.addToCurrentPlayList = new JButton(I18nUtils.getString("ADD_TO_PLAYLIST"), Images.getImage("add.png"));
        this.addToNewPlayList = new JButton(I18nUtils.getString("ADD_TO_NEW_PLAYLIST"), Images.getImage("add.png"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.showElementInfo, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.addToCurrentPlayList, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.addToNewPlayList, gridBagConstraints);
        return jPanel;
    }

    public JTable getSearchResultsTable() {
        return this.searchResultsTable;
    }

    public JButton getShowElementInfo() {
        return this.showElementInfo;
    }

    public JButton getAddToCurrentPlayList() {
        return this.addToCurrentPlayList;
    }

    public JButton getAddToNewPlayList() {
        return this.addToNewPlayList;
    }
}

