/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.atunes.gui.model.ReviewImportTreeTableModel;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.gui.views.dialogs.PatternInputDialog;
import net.sourceforge.atunes.kernel.modules.pattern.AbstractPattern;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.TagAttributesReviewed;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

public final class ReviewImportDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = 8523236886848649698L;
    private JTextArea reviewInstructions;
    private JXTreeTable treeTable;
    private boolean dialogCancelled = true;

    public ReviewImportDialog(JFrame jFrame) {
        super((Window)jFrame, GuiUtils.getComponentWidthForResolution(1280, 1200), GuiUtils.getComponentHeightForResolution(1024, 700), true);
        this.setTitle(I18nUtils.getString("REVIEW_TAGS"));
        this.setContent();
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    private void setContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.treeTable = new JXTreeTable();
        this.treeTable.setShowGrid(false);
        this.treeTable.setSelectionMode(1);
        this.treeTable.setRootVisible(false);
        this.treeTable.setAutoResizeMode(2);
        this.treeTable.getTableHeader().setReorderingAllowed(false);
        this.treeTable.setSurrendersFocusOnKeystroke(true);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        this.reviewInstructions = new CustomTextArea(I18nUtils.getString("REVIEW_TAGS_INSTRUCTIONS"));
        this.reviewInstructions.setEditable(false);
        this.reviewInstructions.setLineWrap(true);
        this.reviewInstructions.setWrapStyleWord(true);
        this.reviewInstructions.setOpaque(false);
        this.reviewInstructions.setBorder(BorderFactory.createEmptyBorder());
        JButton jButton = new JButton(I18nUtils.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReviewImportDialog.this.dialogCancelled = false;
                ReviewImportDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(I18nUtils.getString("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReviewImportDialog.this.setVisible(false);
            }
        });
        jPanel2.add((Component)this.reviewInstructions, "Center");
        final JButton jButton3 = new JButton(StringUtils.getString(I18nUtils.getString("FILL_TAGS_FROM_FOLDER_NAME"), "..."));
        jButton3.setEnabled(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ReviewImportDialog.this.treeTable.getSelectedRows();
                if (nArray.length > 0) {
                    PatternInputDialog patternInputDialog = new PatternInputDialog((Window)ReviewImportDialog.this, true);
                    patternInputDialog.show(AbstractPattern.getMassiveRecognitionPatterns(), (String)ReviewImportDialog.this.treeTable.getValueAt(nArray[0], 0));
                    String string = patternInputDialog.getResult();
                    for (int n : nArray) {
                        Map<String, String> map = AbstractPattern.getPatternMatches(string, (String)ReviewImportDialog.this.treeTable.getValueAt(n, 0), true);
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            ((ReviewImportTreeTableModel)ReviewImportDialog.this.treeTable.getTreeTableModel()).setValueForColumn(n, entry.getKey(), entry.getValue());
                        }
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jButton3.setEnabled(ReviewImportDialog.this.treeTable.getSelectedRowCount() != 0);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane((Component)this.treeTable), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 10;
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.add(jPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ReviewImportDialog.this.dialogCancelled = true;
            }
        });
    }

    public boolean isDialogCancelled() {
        return this.dialogCancelled;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.dialogCancelled = true;
        }
        super.setVisible(bl);
    }

    public void show(List<File> list, List<AudioFile> list2) {
        this.treeTable.setTreeTableModel((TreeTableModel)new ReviewImportTreeTableModel(list, list2, this.treeTable));
        this.treeTable.getColumnExt(0).setPreferredWidth(300);
        ((ReviewImportTreeTableModel)this.treeTable.getTreeTableModel()).setCellEditors();
        this.treeTable.expandAll();
        this.setVisible(true);
    }

    public TagAttributesReviewed getResult() {
        return ((ReviewImportTreeTableModel)this.treeTable.getTreeTableModel()).getTagAttributesReviewed();
    }
}

