/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.RepositoryLoadCancelAction;
import net.sourceforge.atunes.kernel.actions.RepositoryLoadInBackgroundAction;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class RepositoryProgressDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = -3071934230042256578L;
    private JLabel pictureLabel;
    private JLabel label;
    private JLabel progressLabel;
    private JLabel separatorLabel;
    private JLabel totalFilesLabel;
    private JProgressBar progressBar;
    private JLabel folderLabel;
    private JLabel remainingTimeLabel;
    private JButton cancelButton;
    private JButton backgroundButton;
    private MouseListener listener = new GlassPaneMouseListener();

    public RepositoryProgressDialog(JFrame jFrame) {
        super((Window)jFrame, 400, 150, false);
        this.setContent(this.getContent());
        GuiUtils.applyComponentOrientation(this);
        this.backgroundButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.setDefaultCloseOperation(0);
    }

    public static void main(String[] stringArray) {
        new RepositoryProgressDialog(null).setVisible(true);
    }

    public void activateGlassPane() {
        ((JFrame)this.getParent()).getGlassPane().setVisible(true);
        ((JFrame)this.getParent()).getGlassPane().addMouseListener(this.listener);
    }

    public void deactivateGlassPane() {
        ((JFrame)this.getParent()).getGlassPane().removeMouseListener(this.listener);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.pictureLabel = new JLabel(Images.getImage("logo90x90.png"));
        this.label = new JLabel(StringUtils.getString(I18nUtils.getString("LOADING"), "..."));
        this.progressLabel = new JLabel();
        this.separatorLabel = new JLabel(" / ");
        this.totalFilesLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.folderLabel = new JLabel(" ");
        this.remainingTimeLabel = new JLabel(" ");
        this.backgroundButton = new CustomButton(Actions.getAction(RepositoryLoadInBackgroundAction.class));
        this.cancelButton = new CustomButton(Actions.getAction(RepositoryLoadCancelAction.class));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.backgroundButton);
        jPanel2.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)this.pictureLabel, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 20, 0, 20);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.separatorLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 20);
        jPanel.add((Component)this.totalFilesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 20, 10, 20);
        jPanel.add((Component)this.remainingTimeLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public JLabel getFolderLabel() {
        return this.folderLabel;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getProgressLabel() {
        return this.progressLabel;
    }

    public JLabel getRemainingTimeLabel() {
        return this.remainingTimeLabel;
    }

    public JLabel getTotalFilesLabel() {
        return this.totalFilesLabel;
    }

    public void setButtonsEnabled(boolean bl) {
        this.cancelButton.setEnabled(bl);
        this.backgroundButton.setEnabled(bl);
    }

    public void setButtonsVisible(boolean bl) {
        this.cancelButton.setVisible(bl);
        this.backgroundButton.setVisible(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(bl);
    }

    public void showProgressDialog() {
        this.setTitle(I18nUtils.getString("PLEASE_WAIT"));
        this.setVisible(true);
        this.activateGlassPane();
        this.setButtonsVisible(true);
        this.setButtonsEnabled(true);
    }

    public void hideProgressDialog() {
        this.setVisible(false);
        this.deactivateGlassPane();
    }

    private static class GlassPaneMouseListener
    implements MouseListener {
        private GlassPaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

