/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.JXTreeTable;

public final class RadioBrowserDialog
extends CustomFrame {
    private static final long serialVersionUID = 8523236886848649698L;
    private JLabel radioIcon;
    private JLabel browserInstructions;
    private JXTreeTable treeTable;
    private JButton closeButton;

    public RadioBrowserDialog(Component component) {
        super(I18nUtils.getString("RADIO_BROWSER"), GuiUtils.getComponentWidthForResolution(1280, 800), GuiUtils.getComponentHeightForResolution(1024, 700), component);
        this.setContent();
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    private void setContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.treeTable = new JXTreeTable();
        this.treeTable.setShowGrid(false);
        this.treeTable.setSelectionMode(0);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        this.radioIcon = new JLabel(Images.getImage("radio.png"));
        this.browserInstructions = new JLabel(I18nUtils.getString("RADIO_BROWSER_INSTRUCTIONS"));
        this.closeButton = new JButton(I18nUtils.getString("CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RadioBrowserDialog.this.setVisible(false);
            }
        });
        jPanel2.add((Component)this.radioIcon, "West");
        jPanel2.add((Component)this.browserInstructions, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JScrollPane((Component)this.treeTable), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.closeButton, gridBagConstraints);
        this.add(jPanel);
    }

    public JXTreeTable getTreeTable() {
        return this.treeTable;
    }
}

