/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class FileSelectionDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = -1612490779910952274L;
    static transient FileSystemView fsView = FileSystemView.getFileSystemView();
    private JTree fileSystemTree;
    private JList fileSystemList;
    private JLabel selection;
    private JButton okButton;
    private JButton cancelButton;
    boolean dirOnly;
    boolean canceled = true;
    private File selectedDir;
    private File[] selectedFiles;

    public FileSelectionDialog(JFrame jFrame, boolean bl) {
        super((Window)jFrame, 660, 430, true);
        this.dirOnly = bl;
        this.setContent(this.getContent());
        this.setResizable(false);
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    public static void main(String[] stringArray) {
        new FileSelectionDialog(null, true).startDialog();
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(null);
        this.fileSystemTree = new JTree();
        this.fileSystemTree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.fileSystemTree);
        this.fileSystemList = new JList();
        this.setListRenderer();
        JScrollPane jScrollPane2 = new JScrollPane(this.fileSystemList);
        this.selection = new JLabel();
        this.okButton = new CustomButton(null, I18nUtils.getString("OK"));
        this.okButton.addActionListener(new OkButtonActionListener());
        this.cancelButton = new CustomButton(null, I18nUtils.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileSelectionDialog.this.setVisible(false);
            }
        });
        jScrollPane.setSize(220, 320);
        jScrollPane.setLocation(10, 10);
        jPanel.add(jScrollPane);
        jScrollPane2.setSize(400, 320);
        jScrollPane2.setLocation(240, 10);
        jPanel.add(jScrollPane2);
        this.selection.setSize(600, 20);
        this.selection.setLocation(10, 335);
        jPanel.add(this.selection);
        this.okButton.setSize(100, 25);
        this.okButton.setLocation(430, 360);
        jPanel.add(this.okButton);
        this.cancelButton.setSize(100, 25);
        this.cancelButton.setLocation(540, 360);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    File[] getFiles(File file) {
        File[] fileArray = fsView.getFiles(file, true);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (!this.dirOnly) {
                arrayList.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            arrayList.add(file2);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public File getSelectedDir() {
        return this.selectedDir;
    }

    public File[] getSelectedFiles() {
        return Arrays.copyOf(this.selectedFiles, this.selectedFiles.length);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void setListRenderer() {
        this.fileSystemList.setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getListCellRenderer(new FileSystemListCellRendererCode()));
    }

    void setSelectionText(File file) {
        String string = !fsView.isFileSystem(file) ? fsView.getSystemDisplayName(file) : file.getAbsolutePath();
        this.selection.setText(string);
    }

    private void setTree() {
        File[] fileArray = fsView.getRoots();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (File file : fileArray) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new Directory(file));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            Object[] objectArray = fsView.getFiles(file, true);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                if (!fsView.isTraversable((File)object).booleanValue()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new Directory((File)object));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Dummy node"));
            }
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.fileSystemTree.setModel(defaultTreeModel);
        this.fileSystemTree.setRootVisible(false);
        this.fileSystemTree.expandRow(0);
        this.fileSystemTree.setSelectionRow(0);
        this.fileSystemList.setListData(this.getFiles(fileArray[0]));
        this.setSelectionText(fileArray[0]);
        this.setTreeRenderer();
        this.fileSystemTree.addTreeWillExpandListener(new FileSystemTreeTreeWillExpandListener());
        this.fileSystemTree.addTreeSelectionListener(new FileSystemTreeTreeSelectionListener());
        this.fileSystemList.addMouseListener(new FileSystemListMouseAdapter());
    }

    private void setTreeRenderer() {
        this.fileSystemTree.setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTreeCellRenderer(new FileSystemTreeCellRendererCode()));
    }

    public void startDialog() {
        this.canceled = true;
        this.setTree();
        this.setVisible(true);
    }

    static /* synthetic */ File[] access$302(FileSelectionDialog fileSelectionDialog, File[] fileArray) {
        fileSelectionDialog.selectedFiles = fileArray;
        return fileArray;
    }

    private static class Directory {
        public File file;

        Directory(File file) {
            this.file = file;
        }

        public String toString() {
            return fsView.getSystemDisplayName(this.file);
        }
    }

    private static class FileSystemListCellRendererCode
    extends AbstractListCellRendererCode {
        private FileSystemListCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                File file = (File)object;
                jLabel.setText(fsView.getSystemDisplayName(file));
                jLabel.setIcon(fsView.getSystemIcon(file));
                jLabel.setHorizontalAlignment(GuiUtils.getComponentOrientationAsSwingConstant());
                return jLabel;
            }
            return component;
        }
    }

    private static class FileSystemTreeCellRendererCode
    extends AbstractTreeCellRendererCode {
        private FileSystemTreeCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (component instanceof JLabel) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof String) {
                    ((JLabel)component).setText(null);
                    return component;
                }
                Directory directory = (Directory)defaultMutableTreeNode.getUserObject();
                JLabel jLabel = (JLabel)component;
                if (directory != null) {
                    jLabel.setIcon(fsView.getSystemIcon(directory.file));
                }
                return jLabel;
            }
            return component;
        }
    }

    private final class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileSelectionDialog.this.selectedDir = null;
            FileSelectionDialog.access$302(FileSelectionDialog.this, null);
            if (FileSelectionDialog.this.dirOnly) {
                if (FileSelectionDialog.this.fileSystemList.getSelectedValue() != null) {
                    FileSelectionDialog.this.selectedDir = new File(((File)FileSelectionDialog.this.fileSystemList.getSelectedValue()).getAbsolutePath());
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FileSelectionDialog.this.fileSystemTree.getSelectionPath().getLastPathComponent();
                    FileSelectionDialog.this.selectedDir = ((Directory)defaultMutableTreeNode.getUserObject()).file;
                }
            } else if (FileSelectionDialog.this.fileSystemList.getSelectedValues().length > 0) {
                Object[] objectArray = FileSelectionDialog.this.fileSystemList.getSelectedValues();
                FileSelectionDialog.access$302(FileSelectionDialog.this, new File[objectArray.length]);
                System.arraycopy(objectArray, 0, FileSelectionDialog.this.selectedFiles, 0, objectArray.length);
            } else {
                FileSelectionDialog.access$302(FileSelectionDialog.this, new File[1]);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FileSelectionDialog.this.fileSystemTree.getSelectionPath().getLastPathComponent();
                ((FileSelectionDialog)FileSelectionDialog.this).selectedFiles[0] = ((Directory)defaultMutableTreeNode.getUserObject()).file;
            }
            FileSelectionDialog.this.canceled = false;
            FileSelectionDialog.this.setVisible(false);
        }
    }

    private final class FileSystemTreeTreeWillExpandListener
    implements TreeWillExpandListener {
        private FileSystemTreeTreeWillExpandListener() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FileSelectionDialog.this.fileSystemTree.getSelectionPath().getLastPathComponent();
            defaultMutableTreeNode.removeAllChildren();
            Directory directory = (Directory)defaultMutableTreeNode.getUserObject();
            Object[] objectArray = fsView.getFiles(directory.file, true);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                if (!fsView.isTraversable((File)object).booleanValue()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new Directory((File)object));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Dummy node"));
            }
        }
    }

    private final class FileSystemTreeTreeSelectionListener
    implements TreeSelectionListener {
        private FileSystemTreeTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            Directory directory = (Directory)defaultMutableTreeNode.getUserObject();
            FileSelectionDialog.this.setSelectionText(directory.file);
            File[] fileArray = FileSelectionDialog.this.getFiles(directory.file);
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    arrayList.add(file);
                    continue;
                }
                arrayList2.add(file);
            }
            Collections.sort(arrayList);
            Collections.sort(arrayList2);
            arrayList.addAll(arrayList2);
            FileSelectionDialog.this.fileSystemList.setListData(arrayList.toArray());
        }
    }

    private final class FileSystemListMouseAdapter
    extends MouseAdapter {
        private FileSystemListMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            File file = (File)FileSelectionDialog.this.fileSystemList.getSelectedValue();
            FileSelectionDialog.this.setSelectionText(file);
            if (mouseEvent.getClickCount() == 2) {
                Object[] objectArray;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FileSelectionDialog.this.fileSystemTree.getSelectionPath().getLastPathComponent();
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                FileSelectionDialog.this.fileSystemTree.expandPath(treePath);
                Object[] objectArray2 = null;
                for (int i = 0; i < defaultMutableTreeNode.getChildCount() || objectArray2 == null; ++i) {
                    objectArray = (Object[])defaultMutableTreeNode.getChildAt(i);
                    if (!((Directory)objectArray.getUserObject()).file.equals(file)) continue;
                    objectArray2 = objectArray;
                }
                objectArray = new TreeNode[defaultMutableTreeNode.getPath().length + 1];
                for (int i = 0; i < defaultMutableTreeNode.getPath().length; ++i) {
                    objectArray[i] = defaultMutableTreeNode.getPath()[i];
                }
                objectArray[defaultMutableTreeNode.getPath().length] = objectArray2;
                FileSelectionDialog.this.fileSystemTree.setSelectionPath(new TreePath(objectArray));
            }
        }
    }
}

