/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls.playerControls;

import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.PlayAction;

public final class PlayPauseButton
extends JButton {
    private static final long serialVersionUID = 4348041346542204394L;
    private boolean playing;

    public PlayPauseButton(Dimension dimension) {
        super(Actions.getAction(PlayAction.class));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setFocusable(false);
        this.setIcon(Images.getImage("play.png"));
        this.setText(null);
        LookAndFeelSelector.getInstance().getCurrentLookAndFeel().putClientProperties(this);
    }

    public void setPlaying(final boolean bl) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlayPauseButton.this.setPlayingState(bl);
                }
            });
        } else {
            this.setPlayingState(bl);
        }
    }

    private void setPlayingState(boolean bl) {
        if (bl) {
            this.setIcon(Images.getImage("pause.png"));
        } else {
            this.setIcon(Images.getImage("play.png"));
        }
        this.playing = bl;
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

