/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.utils.GuiUtils;

public final class PopUpButton
extends JButton {
    private static final long serialVersionUID = 5193978267971626102L;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    private JPopupMenu menu;
    private int location;
    private int xLocation;
    private int yLocation;
    private List<Component> items = new ArrayList<Component>();

    public PopUpButton(Action action, int n) {
        this.setAction(action);
        this.setPreferredSize(new Dimension(20, 20));
        this.setButton(n);
    }

    public PopUpButton(String string, int n) {
        super(string, null);
        this.setButton(n);
        this.setIcon(n);
        GuiUtils.applyComponentOrientation(this.menu);
    }

    private void setIcon(int n) {
        if (n == 0 || n == 1) {
            this.setIcon(Images.getImage("arrowUp.png"));
        } else if (n == 3 || n == 4) {
            this.setIcon(Images.getImage("arrowDown.png"));
        }
    }

    @Override
    public Component add(Component component) {
        if (!(component instanceof JSeparator)) {
            this.items.add(component);
        }
        Component component2 = this.menu.add(component);
        GuiUtils.applyComponentOrientation(this.menu);
        return component2;
    }

    int getLocationProperty() {
        return this.location;
    }

    public void removeAllItems() {
        this.menu.removeAll();
        this.items.clear();
    }

    private void setButton(int n) {
        this.location = n;
        this.menu = new JPopupMenu();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpButton.this.setMenuLocation(PopUpButton.this.getLocationProperty());
                PopUpButton.this.menu.show(PopUpButton.this, PopUpButton.this.xLocation, PopUpButton.this.yLocation);
            }
        });
    }

    void setMenuLocation(int n) {
        if (!this.items.isEmpty()) {
            this.yLocation = n == 0 || n == 1 ? -((int)this.items.get(0).getPreferredSize().getHeight()) * this.items.size() - 5 : 21;
            if (n == 0 || n == 3) {
                int n2 = 0;
                for (int i = 0; i < this.items.size(); ++i) {
                    if ((int)this.items.get(i).getPreferredSize().getWidth() <= n2) continue;
                    n2 = (int)this.items.get(i).getPreferredSize().getWidth();
                }
                this.xLocation = -n2 + (int)this.getPreferredSize().getWidth();
            } else {
                this.xLocation = 0;
            }
        }
    }
}

