/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.gui.views.dialogs.ColumnSetSelectorDialog;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.utils.I18nUtils;

public class ColumnSetPopupMenu {
    private JMenuItem arrangeColumns;

    public ColumnSetPopupMenu(JTable jTable, AbstractCommonColumnModel abstractCommonColumnModel) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.arrangeColumns = new JMenuItem(I18nUtils.getString("ARRANGE_COLUMNS"));
        jPopupMenu.add(this.arrangeColumns);
        this.arrangeColumns.addActionListener(new SelectColumnsActionListener(abstractCommonColumnModel));
        jTable.getTableHeader().addMouseListener(new ColumnSetTableHeaderMouseAdapter(jPopupMenu, jTable));
    }

    public static void selectColumns(AbstractCommonColumnModel abstractCommonColumnModel) {
        ColumnSetSelectorDialog columnSetSelectorDialog = GuiHandler.getInstance().getColumnSelector();
        columnSetSelectorDialog.setColumnSet(abstractCommonColumnModel.getColumnSet());
        columnSetSelectorDialog.setVisible(true);
        abstractCommonColumnModel.arrangeColumns(true);
    }

    public void enableArrangeColumns(boolean bl) {
        this.arrangeColumns.setEnabled(bl);
    }

    private static final class SelectColumnsActionListener
    implements ActionListener {
        private final AbstractCommonColumnModel model;

        private SelectColumnsActionListener(AbstractCommonColumnModel abstractCommonColumnModel) {
            this.model = abstractCommonColumnModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnSetPopupMenu.selectColumns(this.model);
        }
    }

    private static final class ColumnSetTableHeaderMouseAdapter
    extends MouseAdapter {
        private final JPopupMenu rightMenu;
        private final JTable table;

        private ColumnSetTableHeaderMouseAdapter(JPopupMenu jPopupMenu, JTable jTable) {
            this.rightMenu = jPopupMenu;
            this.table = jTable;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                this.rightMenu.show(this.table.getTableHeader(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

