/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.renderers;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.AudioFileStats;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class ColumnRenderers {
    private ColumnRenderers() {
    }

    public static void addRenderers(JTable jTable, AbstractCommonColumnModel abstractCommonColumnModel) {
        jTable.setDefaultRenderer(Integer.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(abstractCommonColumnModel.getRendererCodeFor(Integer.class)));
        jTable.setDefaultRenderer(ImageIcon.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(abstractCommonColumnModel.getRendererCodeFor(ImageIcon.class)));
        jTable.setDefaultRenderer(String.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(abstractCommonColumnModel.getRendererCodeFor(String.class)));
        jTable.setDefaultRenderer(JLabel.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(abstractCommonColumnModel.getRendererCodeFor(JLabel.class)));
        jTable.setDefaultRenderer(NavigationTableModel.Property.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(abstractCommonColumnModel.getRendererCodeFor(NavigationTableModel.Property.class)));
    }

    static void setFontForRow(JLabel jLabel, int n) {
        jLabel.setFont(PlayListHandler.getInstance().isCurrentVisibleRowPlaying(n) ? Fonts.getPlayListSelectedItemFont() : Fonts.getPlayListFont());
    }

    static String getToolTipForAudioObject(AudioObject audioObject) {
        if (audioObject instanceof AudioFile) {
            AudioFileStats audioFileStats = StatisticsHandler.getInstance().getAudioFileStatistics((AudioFile)audioObject);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(audioObject.getTitleOrFileName()).append(" - ");
            stringBuilder.append(audioObject.getArtist()).append(" - ");
            if (audioFileStats == null) {
                stringBuilder.append(I18nUtils.getString("SONG_NEVER_PLAYED"));
            } else {
                stringBuilder.append(I18nUtils.getString("LAST_DATE_PLAYED"));
                stringBuilder.append(": ");
                stringBuilder.append(DateUtils.toString(audioFileStats.getLastPlayed()));
                stringBuilder.append(" - ");
                stringBuilder.append(I18nUtils.getString("TIMES_PLAYED"));
                stringBuilder.append(": ");
                stringBuilder.append(audioFileStats.getTimesPlayed());
            }
            return stringBuilder.toString();
        }
        return audioObject.getTitleOrFileName();
    }
}

