/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.command.CommandHandler;

public final class ApplicationArguments {
    public static final String DEBUG = "debug";
    public static final String IGNORE_LOOK_AND_FEEL = "ignore-look-and-feel";
    public static final String ALLOW_MULTIPLE_INSTANCE = "multiple-instance";
    public static final String USE_CONFIG_FOLDER = "use-config-folder=";
    public static final String USE_REPOSITORY_CONFIG_FOLDER = "use-repository-config-folder=";
    public static final String NO_UPDATE = "no-update";
    private static List<String> savedArguments;

    private ApplicationArguments() {
    }

    public static String getUserConfigFolder(List<String> list) {
        String string = null;
        if (list != null) {
            for (String string2 : list) {
                if (!string2.toLowerCase().startsWith(USE_CONFIG_FOLDER)) continue;
                string = string2.substring(USE_CONFIG_FOLDER.length());
            }
        }
        return string;
    }

    public static String getRepositoryConfigFolder(List<String> list) {
        String string = null;
        if (list != null) {
            for (String string2 : list) {
                if (!string2.toLowerCase().startsWith(USE_REPOSITORY_CONFIG_FOLDER)) continue;
                string = string2.substring(USE_REPOSITORY_CONFIG_FOLDER.length());
            }
        }
        return string;
    }

    public static void saveArguments(List<String> list) {
        savedArguments = new ArrayList<String>();
        ApplicationArguments.checkAndSave(list, DEBUG);
        ApplicationArguments.checkAndSave(list, IGNORE_LOOK_AND_FEEL);
        ApplicationArguments.checkAndSave(list, ALLOW_MULTIPLE_INSTANCE);
        ApplicationArguments.checkAndSave(list, USE_CONFIG_FOLDER);
        ApplicationArguments.checkAndSave(list, USE_REPOSITORY_CONFIG_FOLDER);
        ApplicationArguments.checkAndSave(list, NO_UPDATE);
        ApplicationArguments.checkAndSave(list, "command:");
    }

    private static void checkAndSave(List<String> list, String string) {
        if (list != null) {
            for (String string2 : list) {
                if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                savedArguments.add(string2);
            }
        }
    }

    public static String getSavedArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : savedArguments) {
            if (CommandHandler.getInstance().isValidCommand(string)) continue;
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public static String getSavedCommands() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : savedArguments) {
            if (!CommandHandler.getInstance().isValidCommand(string)) continue;
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }
}

