/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.UndoRecord;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.texture.Texture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Vector;

public class SkinDialog
extends BDialog {
    private LayoutWindow window;
    private BList curveList;
    private BCheckBox reverseBox;
    private BButton upButton;
    private BButton downButton;
    private BButton okButton;
    private BButton cancelButton;
    private ObjectPreviewCanvas preview;
    private ObjectInfo[] curve;
    private boolean[] reverse;
    private Vec3 centerOffset;
    private static int counter = 1;

    public SkinDialog(LayoutWindow window, Vector curves) {
        super((WindowWidget)window, "Skin", true);
        this.window = window;
        this.curve = new ObjectInfo[curves.size()];
        this.reverse = new boolean[curves.size()];
        FormContainer content = new FormContainer(3, 2);
        this.setContent((Widget)BOutline.createEmptyBorder((Widget)content, (int)UIUtilities.getStandardDialogInsets()));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.curveList = new BList();
        content.add((Widget)UIUtilities.createScrollingList((BList)this.curveList), 0, 0);
        for (int i = 0; i < curves.size(); ++i) {
            this.curve[i] = (ObjectInfo)curves.elementAt(i);
            this.curveList.add((Object)this.curve[i].getName());
        }
        this.curveList.setMultipleSelectionEnabled(false);
        this.curveList.setSelected(0, true);
        this.curveList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        ColumnContainer col = new ColumnContainer();
        content.add((Widget)col, 1, 0);
        col.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.upButton = new BButton("Move Up");
        col.add((Widget)this.upButton);
        this.upButton.addEventLink(CommandEvent.class, (Object)this, "doMoveUp");
        this.downButton = new BButton("Move Down");
        col.add((Widget)this.downButton);
        this.downButton.addEventLink(CommandEvent.class, (Object)this, "doMoveDown");
        this.reverseBox = new BCheckBox("Reverse Direction", false);
        col.add((Widget)this.reverseBox);
        this.reverseBox.addEventLink(ValueChangedEvent.class, (Object)this, "selectionChanged");
        this.preview = new ObjectPreviewCanvas(null);
        content.add((Widget)this.preview, 2, 0);
        this.preview.setPreferredSize(new Dimension(150, 150));
        RowContainer buttons = new RowContainer();
        content.add((Widget)buttons, 0, 1, 3, 1, new LayoutInfo());
        this.okButton = Translate.button((String)"ok", (Object)((Object)this), (String)"doOk");
        buttons.add((Widget)this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (Object)((Object)this), (String)"dispose");
        buttons.add((Widget)this.cancelButton);
        this.makeObject();
        this.pack();
        UIUtilities.centerDialog((BDialog)this, (WindowWidget)window);
        this.updateComponents();
        this.setVisible(true);
    }

    private void selectionChanged(WidgetEvent e) {
        if (e.getWidget() == this.reverseBox) {
            this.reverse[this.curveList.getSelectedIndex()] = this.reverseBox.getState();
        }
        this.makeObject();
        this.updateComponents();
    }

    private void updateComponents() {
        int which = this.curveList.getSelectedIndex();
        this.upButton.setEnabled(which > 0);
        this.downButton.setEnabled(which < this.curve.length - 1);
        this.reverseBox.setState(which > -1 && this.reverse[which]);
    }

    private void doOk() {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        coords.setOrigin(coords.getOrigin().plus(this.centerOffset));
        this.window.addObject(this.preview.getObject().getObject(), coords, "Skinned Object " + counter++, null);
        this.window.setSelection(this.window.getScene().getNumObjects() - 1);
        this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(this.window.getScene().getNumObjects() - 1)}));
        this.window.updateImage();
        this.dispose();
    }

    private void doMoveUp() {
        int which = this.curveList.getSelectedIndex();
        ObjectInfo swap1 = this.curve[which];
        this.curve[which] = this.curve[which - 1];
        this.curve[which - 1] = swap1;
        boolean swap2 = this.reverse[which];
        this.reverse[which] = this.reverse[which - 1];
        this.reverse[which - 1] = swap2;
        Object swap3 = this.curveList.getItem(which);
        this.curveList.remove(which);
        this.curveList.add(which - 1, swap3);
        this.curveList.setSelected(which - 1, true);
        this.makeObject();
        this.updateComponents();
    }

    private void doMoveDown() {
        int which = this.curveList.getSelectedIndex();
        ObjectInfo swap1 = this.curve[which];
        this.curve[which] = this.curve[which + 1];
        this.curve[which + 1] = swap1;
        boolean swap2 = this.reverse[which];
        this.reverse[which] = this.reverse[which + 1];
        this.reverse[which + 1] = swap2;
        Object swap3 = this.curveList.getItem(which);
        this.curveList.remove(which);
        this.curveList.add(which + 1, swap3);
        this.curveList.setSelected(which + 1, true);
        this.makeObject();
        this.updateComponents();
    }

    private void makeObject() {
        int i;
        Vec3[][] v = new Vec3[this.curve.length][];
        Vec3 center = new Vec3();
        float[] us = new float[this.curve.length];
        float[] vs = new float[((Curve)this.curve[0].getObject()).getVertices().length];
        int smoothMethod = 2;
        boolean closed = false;
        for (i = 0; i < this.curve.length; ++i) {
            Curve cv = (Curve)this.curve[i].getObject();
            MeshVertex[] vert = cv.getVertices();
            v[i] = new Vec3[vert.length];
            float[] smooth = cv.getSmoothness();
            if (cv.getSmoothingMethod() > smoothMethod) {
                smoothMethod = cv.getSmoothingMethod();
            }
            closed |= cv.isClosed();
            for (int j = 0; j < vert.length; ++j) {
                int k = this.reverse[i] ? vert.length - j - 1 : j;
                v[i][j] = this.curve[i].getCoords().fromLocal().times(vert[k].r);
                center.add(v[i][j]);
                if (cv.getSmoothingMethod() == 0) continue;
                int n = j;
                vs[n] = vs[n] + smooth[k];
            }
            us[i] = 1.0f;
        }
        i = 0;
        while (i < vs.length) {
            int n = i++;
            vs[n] = vs[n] / (float)this.curve.length;
        }
        center.scale(1.0 / (double)(v.length * v[0].length));
        for (i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[i].length; ++j) {
                v[i][j].subtract(center);
            }
        }
        this.centerOffset = center;
        SplineMesh mesh = new SplineMesh((Vec3[][])v, us, vs, smoothMethod, false, closed);
        Texture tex = this.window.getScene().getDefaultTexture();
        mesh.setTexture(tex, tex.getDefaultMapping((Object3D)mesh));
        mesh.makeRightSideOut();
        this.preview.setObject((Object3D)mesh);
        this.preview.repaint();
    }
}

