/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ArtOfIllusion;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;

public class POVExporter {
    static boolean DEBUG = false;
    static int DIRECTIONAL_LIGHT_DISTANCE = 10000;
    static int MAXIMAL_LIGHT_FADE_DISTANCE = 10000;
    static int TIGHTNESS = 10;
    static char CHAR_REPLACE = (char)95;
    static final String TEXTURE_NAME_PREFIX = "AOI";
    static final char REPLACEMENT_CHARACTER = '_';
    static final String FIX_SEPARATOR = ".";
    static String exportFileName = "Untitled";

    public static void exportFile(BFrame parent, Scene theScene) {
        boolean bIncludeFile;
        ValueField errorField = new ValueField(0.05, 3);
        BCheckBox smoothBox = new BCheckBox("Smooth Meshes", true);
        BCheckBox includeBox = new BCheckBox("Produce Extra Includefile for Povray textures", true);
        BComboBox exportChoice = new BComboBox((Object[])new String[]{Translate.text((String)"exportWholeScene"), Translate.text((String)"selectedObjectsOnly")});
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToPOV"), new Widget[]{exportChoice, Translate.label((String)"maxSurfaceError"), errorField, includeBox, smoothBox}, new String[]{"", "", "", "", ""}) : new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToPOV"), new Widget[]{Translate.label((String)"maxSurfaceError"), errorField, includeBox, smoothBox}, new String[]{"", "", "", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text((String)"exportToPOV"));
        String suffix = ".pov";
        String suffix2 = ".inc";
        fc.setSelectedFile(new File(exportFileName + suffix));
        if (ArtOfIllusion.getCurrentDirectory() != null) {
            fc.setDirectory(new File(ArtOfIllusion.getCurrentDirectory()));
        }
        if (!fc.showDialog((Widget)parent)) {
            return;
        }
        File path = fc.getDirectory();
        int endpos = fc.getSelectedFile().getName().indexOf(FIX_SEPARATOR);
        if (endpos == -1) {
            endpos = fc.getSelectedFile().getName().length();
        }
        exportFileName = fc.getSelectedFile().getName().substring(0, endpos);
        ArtOfIllusion.setCurrentDirectory((String)fc.getDirectory().getAbsolutePath());
        File f = null;
        f = new File(path, exportFileName + suffix);
        if (f.exists()) {
            String[] options = new String[]{Translate.text((String)"Yes"), Translate.text((String)"No")};
            int choice = new BStandardDialog("", (Object)Translate.text((String)"overwriteFile", (Object)(exportFileName + suffix)), BStandardDialog.QUESTION).showOptionDialog((Widget)parent, options, options[1]);
            if (choice == 1) {
                return;
            }
        }
        if ((bIncludeFile = includeBox.getState()) && (f = new File(path, exportFileName + suffix2)).exists()) {
            String[] options = new String[]{Translate.text((String)"Yes"), Translate.text((String)"No")};
            int choice = new BStandardDialog("", (Object)Translate.text((String)"overwriteFile", (Object)(exportFileName + suffix2)), BStandardDialog.QUESTION).showOptionDialog((Widget)parent, options, options[1]);
            if (choice == 1) {
                bIncludeFile = false;
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(path, exportFileName + suffix));
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FileOutputStream fos2 = null;
            BufferedOutputStream bos2 = null;
            if (bIncludeFile) {
                fos2 = new FileOutputStream(new File(path, exportFileName + suffix2));
                bos2 = new BufferedOutputStream(fos2);
            }
            POVExporter.writeScene(theScene, bos, exportChoice.getSelectedIndex() == 0, errorField.getValue(), smoothBox.getState(), bos2, exportFileName + suffix2);
            bos.close();
            if (bos2 != null) {
                bos2.close();
            }
            fos.close();
            if (fos2 != null) {
                fos2.close();
            }
        }
        catch (IOException ex) {
            new BStandardDialog("", (Object)new String[]{Translate.text((String)"errorExportingScene"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog((Widget)parent);
        }
    }

    static void writeScene(Scene theScene, OutputStream os, boolean wholeScene, double tol, boolean smooth, OutputStream os2, String includeFileName) {
        int i;
        PrintWriter out;
        PrintWriter out2 = out = new PrintWriter(os);
        boolean bIncludeFile = false;
        if (os2 != null) {
            out2 = new PrintWriter(os2);
            bIncludeFile = true;
        }
        POVExporter.write("// POV V3.5", out, 0);
        POVExporter.write("// Produced by Art of Illusion (Peter Eastman) " + ArtOfIllusion.getVersion(), out, 0);
        POVExporter.write("//   and POVExporter plugin (Norbert Krieg) version 1.11", out, 0);
        POVExporter.write("//   creation date: " + new Date().toString(), out, 0);
        POVExporter.write("", out, 0);
        if (bIncludeFile) {
            POVExporter.write("// POV V3.5 (include file)", out2, 0);
            POVExporter.write("// Produced by Art of Illusion (Peter Eastman) " + ArtOfIllusion.getVersion(), out2, 0);
            POVExporter.write("//   and POVExporter plugin (Norbert Krieg) version 1.11", out2, 0);
            POVExporter.write("//   creation date: " + new Date().toString(), out2, 0);
            POVExporter.write("", out2, 0);
        }
        POVExporter.write("#version 3.5;", out, 0);
        POVExporter.write("", out, 0);
        if (wholeScene) {
            POVExporter.write("// Global settings", out, 0);
            RGBColor color = theScene.getEnvironmentColor();
            POVExporter.write("background { color rgb <" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "> }", out, 0);
            POVExporter.write("global_settings {", out, 0);
            color = theScene.getAmbientColor();
            POVExporter.write("ambient_light <" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ">", out, 1);
            POVExporter.write("}", out, 0);
            if (theScene.getFogState()) {
                color = theScene.getFogColor();
                POVExporter.write("fog {", out, 0);
                POVExporter.write("color <" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ">", out, 1);
                POVExporter.write("distance " + theScene.getFogDistance(), out, 1);
                POVExporter.write("}", out, 0);
            }
        }
        POVExporter.write("", out, 0);
        int[] selected = theScene.getSelection();
        int maxIndex = 0;
        POVExporter.write("// texture declarations", out2, 0);
        if (wholeScene) {
            maxIndex = theScene.getNumObjects();
            for (i = 0; i < maxIndex; ++i) {
                POVExporter.writeTexture(theScene, theScene.getObject(i), out2, 1);
            }
        } else {
            maxIndex = selected.length;
            for (i = 0; i < maxIndex; ++i) {
                POVExporter.writeTexture(theScene, theScene.getObject(selected[i]), out2, 1);
            }
        }
        out2.flush();
        if (bIncludeFile) {
            POVExporter.write("#include \"" + includeFileName + "\"", out, 0);
        }
        POVExporter.write("", out, 0);
        if (wholeScene) {
            maxIndex = theScene.getNumObjects();
            for (i = 0; i < maxIndex; ++i) {
                POVExporter.writeObjects(theScene, theScene.getObject(i), out, smooth, tol);
            }
        } else {
            maxIndex = selected.length;
            for (i = 0; i < maxIndex; ++i) {
                POVExporter.writeObjects(theScene, theScene.getObject(selected[i]), out, smooth, tol);
            }
        }
        out.flush();
    }

    static void write(String str, PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.print(str);
        out.println();
    }

    static String getVec3String(Vec3 vec) {
        if (vec == null) {
            return "<1,0,0>";
        }
        double x = (double)Math.round(vec.x * 1000000.0) / 1000000.0;
        double y = (double)Math.round(vec.y * 1000000.0) / 1000000.0;
        double z = (double)Math.round(vec.z * 1000000.0) / 1000000.0;
        return "<" + x + "," + y + "," + z + ">";
    }

    private static String cleanName(String oldName) {
        StringBuffer workString = new StringBuffer(oldName.trim());
        for (int i = 0; i < workString.length(); ++i) {
            char c = workString.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            workString.setCharAt(i, CHAR_REPLACE);
        }
        return workString.toString();
    }

    private static void writeRotation(CoordinateSystem coords, PrintWriter out, int indent) {
        double[] rot = coords.getRotationAngles();
        POVExporter.write("rotate <0,0," + -rot[2] + ">", out, indent);
        POVExporter.write("rotate <" + -rot[0] + ",0,0>", out, indent);
        POVExporter.write("rotate <0," + -rot[1] + ",0>", out, indent);
    }

    static void writeTexture(Scene theScene, ObjectInfo obj, PrintWriter out, int indent) {
        Texture tex = obj.getObject().getTexture();
        if (tex == null) {
            return;
        }
        TextureSpec spec = new TextureSpec();
        tex.getAverageSpec(spec, theScene.getTime(), obj.getObject().getAverageParameterValues());
        String texName = POVExporter.cleanName(tex.getName());
        if (tex.getID() == 1) {
            texName = POVExporter.cleanName(obj.getName());
        }
        if (DEBUG) {
            System.err.println("Texture " + tex.getName() + ":\t" + tex.getID());
        }
        POVExporter.write("#declare AOI" + texName + " = ", out, 0);
        POVExporter.write("texture {", out, indent);
        POVExporter.write("pigment {", out, indent + 1);
        POVExporter.write("color <" + spec.diffuse.getRed() + "," + spec.diffuse.getGreen() + "," + spec.diffuse.getBlue() + ">", out, indent + 2);
        POVExporter.write("}", out, indent + 1);
        POVExporter.write("finish {", out, indent + 1);
        POVExporter.write("ambient " + Math.max(spec.emissive.getRed(), Math.max(spec.emissive.getGreen(), spec.emissive.getBlue())), out, indent + 2);
        POVExporter.write("specular " + Math.max(spec.specular.getRed(), Math.max(spec.specular.getGreen(), spec.specular.getBlue())), out, indent + 2);
        POVExporter.write("roughness " + spec.roughness, out, indent + 2);
        POVExporter.write("}", out, indent + 1);
        POVExporter.write("}", out, indent);
    }

    static void writeObjects(Scene theScene, ObjectInfo obj, PrintWriter out, boolean smooth, double tolerance) {
        if (!obj.isVisible()) {
            return;
        }
        if (obj.getObject() instanceof SceneCamera) {
            POVExporter.write("// Camera settings", out, 0);
            ObjectInfo info = obj;
            CoordinateSystem coords = info.getCoords().duplicate();
            Vec3 orig = coords.getOrigin();
            String location = "location " + POVExporter.getVec3String(orig);
            Vec3 zdir = coords.getZDirection();
            Vec3 updir = coords.getUpDirection();
            Vec3 rightdir = zdir.cross(updir).times(1.33);
            String direction = "direction <" + zdir.x + "," + zdir.y + "," + zdir.z + ">";
            String up = "up <" + updir.x + "," + updir.y + "," + updir.z + ">";
            String right = "right <" + rightdir.x + "," + rightdir.y + "," + rightdir.z + ">";
            String angle = "angle " + ((SceneCamera)obj.getObject()).getFieldOfView() * 1.33;
            POVExporter.write("camera {", out, 0);
            POVExporter.write("perspective", out, 1);
            POVExporter.write(location, out, 1);
            POVExporter.write(direction, out, 1);
            POVExporter.write(up, out, 1);
            POVExporter.write(right, out, 1);
            POVExporter.write(angle, out, 1);
            POVExporter.write("}", out, 0);
            if (DEBUG) {
                System.err.println("Camera:");
                System.err.println("// Standort:\t" + orig.toString());
                System.err.println("// Blickrichtung:\t" + coords.getZDirection().toString());
                System.err.println("// Up-Richtung:\t" + coords.getUpDirection().toString());
                System.err.println("// Right (for aspect ratio):\t" + coords.getUpDirection().cross(coords.getZDirection()).times(1.33).toString());
            }
            POVExporter.write("", out, 0);
        } else if (obj.getObject() instanceof DirectionalLight) {
            POVExporter.write("// Directional light (simulated as far away point light distance=" + DIRECTIONAL_LIGHT_DISTANCE + "units)", out, 0);
            DirectionalLight light = (DirectionalLight)obj.getObject();
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 zdir = coords.getZDirection();
            float intensity = light.getIntensity();
            RGBColor color = light.getColor().duplicate();
            color.scale(intensity);
            zdir.normalize();
            zdir.scale((double)(-DIRECTIONAL_LIGHT_DISTANCE));
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("light_source {", out, 0);
            POVExporter.write(POVExporter.getVec3String(zdir), out, 1);
            POVExporter.write("color <" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ">", out, 1);
            POVExporter.write("parallel", out, 1);
            POVExporter.write("point_at " + POVExporter.getVec3String(new Vec3(0.0, 0.0, 0.0)), out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                System.err.println("// Directional Light source");
                System.err.println("// --> point light:");
                System.err.println("// Position:\t" + zdir.toString());
                System.err.println("// Color:\t" + color.toString());
            }
        } else if (obj.getObject() instanceof PointLight) {
            POVExporter.write("// Point light", out, 0);
            POVExporter.write("// decay is different than in Art Of Illusion", out, 0);
            POVExporter.write("// the point light source has actually no \"radius\"", out, 0);
            PointLight light = (PointLight)obj.getObject();
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 orig = coords.getOrigin();
            float intensity = light.getIntensity();
            RGBColor color = light.getColor().duplicate();
            color.scale(intensity);
            float dr = light.getDecayRate();
            double fadeDistance = MAXIMAL_LIGHT_FADE_DISTANCE;
            if ((double)dr != 0.0) {
                fadeDistance = 0.5 / new Float(dr).doubleValue();
            }
            double fadePower = 2.0;
            if (fadeDistance >= 5.0) {
                fadePower = 1.0;
            }
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("light_source {", out, 0);
            POVExporter.write(POVExporter.getVec3String(orig), out, 1);
            POVExporter.write("color <" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ">", out, 1);
            if (light.getType() != 0) {
                POVExporter.write("shadowless", out, 1);
            }
            POVExporter.write("fade_distance " + fadeDistance, out, 1);
            POVExporter.write("fade_power " + fadePower, out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                System.err.println("// Point Light source");
                System.err.println("// --> point light:");
                System.err.println("// Position:\t" + orig.toString());
                System.err.println("// FadeDistance:\t" + fadeDistance);
                System.err.println("// FadePower:\t" + fadePower);
            }
        } else if (obj.getObject() instanceof SpotLight) {
            POVExporter.write("// Spot light", out, 0);
            POVExporter.write("// the spot light source has actually no \"radius\"", out, 0);
            SpotLight light = (SpotLight)obj.getObject();
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 zdir = coords.getZDirection();
            Vec3 orig = coords.getOrigin();
            Vec3 pointat = orig.plus(zdir);
            RGBColor color = light.getColor().duplicate();
            float intensity = light.getIntensity();
            color.scale(intensity);
            double radius = light.getAngle() / 2.0 * (1.0 - light.getFalloff());
            double falloff = light.getAngle() / 2.0;
            float dr = light.getDecayRate();
            double fadeDistance = MAXIMAL_LIGHT_FADE_DISTANCE;
            if ((double)dr != 0.0) {
                fadeDistance = 0.5 / new Float(dr).doubleValue();
            }
            double fadePower = 2.0;
            if (fadeDistance >= 5.0) {
                fadePower = 1.0;
            }
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("light_source {", out, 0);
            POVExporter.write(POVExporter.getVec3String(orig), out, 1);
            POVExporter.write("color <" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ">", out, 1);
            POVExporter.write("spotlight", out, 1);
            POVExporter.write("point_at " + POVExporter.getVec3String(pointat), out, 1);
            POVExporter.write("radius " + radius, out, 1);
            POVExporter.write("falloff " + falloff, out, 1);
            POVExporter.write("tightness " + TIGHTNESS, out, 1);
            if (light.getType() != 0) {
                POVExporter.write("shadowless", out, 1);
            }
            POVExporter.write("fade_distance " + fadeDistance, out, 1);
            POVExporter.write("fade_power " + fadePower, out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                System.err.println("// Spotlight source");
                System.err.println("// --> spot light:");
                System.err.println("// Position:\t" + orig.toString());
                System.err.println("// Point at:\t" + pointat.toString());
                System.err.println("// Color:\t" + color.toString());
                System.err.println("// Radius:\t" + radius);
                System.err.println("// Falloff:\t" + falloff);
                System.err.println("// Tightness:\t" + TIGHTNESS);
                if (light.getType() != 0) {
                    System.err.println("shadowless");
                }
                System.err.println("// FadeDistance:\t" + fadeDistance);
                System.err.println("// FadePower:\t" + fadePower);
            }
        } else if (obj.getObject() instanceof Cube) {
            POVExporter.write("// Cube settings", out, 0);
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 size = info.getBounds().getSize();
            Vec3 orig = coords.getOrigin();
            String texName = POVExporter.cleanName(info.getObject().getTexture().getName());
            if (info.getObject().getTexture().getID() == 1) {
                texName = POVExporter.cleanName(info.getName());
            }
            size.scale(0.5);
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("box {", out, 0);
            POVExporter.write(POVExporter.getVec3String(new Vec3(-1.0, -1.0, -1.0)) + ", " + POVExporter.getVec3String(new Vec3(1.0, 1.0, 1.0)), out, 1);
            POVExporter.write("scale " + POVExporter.getVec3String(size), out, 1);
            POVExporter.writeRotation(coords, out, 1);
            POVExporter.write("translate " + POVExporter.getVec3String(orig), out, 1);
            POVExporter.write("texture { AOI" + texName + " }", out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                System.err.println("Box:");
                System.err.println("Mittelpunkt:" + orig.toString());
                System.err.println("Gr\u02c6\ufb02e:" + size.times(2.0).toString());
                System.err.println("Eckpunkte:\t(lu): " + POVExporter.getVec3String(orig.minus(size)));
                System.err.println("          \t(ro): " + POVExporter.getVec3String(orig.plus(size)));
                System.err.println();
            }
        } else if (obj.getObject() instanceof Sphere) {
            POVExporter.write("// Sphere settings", out, 0);
            Sphere sphere = (Sphere)obj.getObject();
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 size = sphere.getRadii();
            Vec3 orig = coords.getOrigin();
            String texName = POVExporter.cleanName(info.getObject().getTexture().getName());
            if (info.getObject().getTexture().getID() == 1) {
                texName = POVExporter.cleanName(info.getName());
            }
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("sphere {", out, 0);
            POVExporter.write("<0,0,0>, 1", out, 1);
            POVExporter.write("scale " + POVExporter.getVec3String(size), out, 1);
            POVExporter.writeRotation(coords, out, 1);
            POVExporter.write("translate " + POVExporter.getVec3String(orig), out, 1);
            POVExporter.write("texture { AOI" + texName + " }", out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                double[] rot = coords.getRotationAngles();
                System.err.println("Sphere:");
                System.err.println("// Mittelpunkt:\t" + orig.toString());
                System.err.println("// Gr\u02c6\ufb02e:\t" + size.times(2.0).toString());
                System.err.println("// Rotation (x-axis):\t" + rot[0]);
                System.err.println("//          (y-axis):\t" + rot[1]);
                System.err.println("//          (z-axis):\t" + rot[2]);
                System.err.println();
            }
        } else if (obj.getObject() instanceof Cylinder) {
            POVExporter.write("// Cylinder settings", out, 0);
            Cylinder cyl = (Cylinder)obj.getObject();
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 orig = coords.getOrigin();
            double ratio = cyl.getRatio();
            Vec3 size = cyl.getBounds().getSize();
            String texName = POVExporter.cleanName(info.getObject().getTexture().getName());
            if (info.getObject().getTexture().getID() == 1) {
                texName = POVExporter.cleanName(info.getName());
            }
            size.scale(0.5);
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("cone {", out, 0);
            POVExporter.write("<0,-1,0>, 1, <0,1,0>, " + ratio, out, 1);
            POVExporter.write("scale " + POVExporter.getVec3String(size), out, 1);
            POVExporter.writeRotation(coords, out, 1);
            POVExporter.write("translate " + POVExporter.getVec3String(orig), out, 1);
            POVExporter.write("texture { AOI" + texName + " }", out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                double[] rot = coords.getRotationAngles();
                System.err.println("Cone:");
                System.err.println("// Mittelpunkt:\t" + orig.toString());
                System.err.println("// Gr\u02c6\ufb02e:\t" + size.times(2.0).toString());
                System.err.println("// Rotation (x-axis):\t" + rot[0]);
                System.err.println("//          (y-axis):\t" + rot[1]);
                System.err.println("//          (z-axis):\t" + rot[2]);
                System.err.println();
            }
        } else if (obj.getObject() instanceof TriangleMesh && !smooth) {
            int j;
            POVExporter.write("// Triangle Mesh (mesh2) not smoothed", out, 0);
            TriangleMesh trimesh = (TriangleMesh)obj.getObject();
            ObjectInfo info = obj.duplicate();
            CoordinateSystem coords = info.getCoords();
            Vec3 orig = coords.getOrigin();
            String texName = POVExporter.cleanName(info.getObject().getTexture().getName());
            if (info.getObject().getTexture().getID() == 1) {
                texName = POVExporter.cleanName(info.getName());
            }
            MeshVertex[] vert = trimesh.getVertices();
            TriangleMesh.Face[] face = trimesh.getFaces();
            POVExporter.write("// " + info.getName(), out, 0);
            POVExporter.write("mesh2 {", out, 0);
            POVExporter.write("vertex_vectors {", out, 1);
            POVExporter.write(vert.length + ",", out, 2);
            for (j = 0; j < vert.length; ++j) {
                if (j != vert.length - 1) {
                    POVExporter.write(POVExporter.getVec3String(vert[j].r) + ",", out, 2);
                    continue;
                }
                POVExporter.write(POVExporter.getVec3String(vert[j].r), out, 2);
            }
            POVExporter.write("}", out, 1);
            POVExporter.write("face_indices {", out, 1);
            POVExporter.write(face.length + ",", out, 2);
            for (j = 0; j < face.length; ++j) {
                if (j != face.length - 1) {
                    POVExporter.write("<" + face[j].v1 + "," + face[j].v2 + "," + face[j].v3 + "> ,", out, 2);
                    continue;
                }
                POVExporter.write("<" + face[j].v1 + "," + face[j].v2 + "," + face[j].v3 + ">", out, 2);
            }
            POVExporter.write("}", out, 1);
            POVExporter.write("texture { AOI" + texName + " }", out, 1);
            POVExporter.writeRotation(coords, out, 1);
            POVExporter.write("translate " + POVExporter.getVec3String(orig), out, 1);
            POVExporter.write("}", out, 0);
            POVExporter.write("", out, 0);
            if (DEBUG) {
                System.err.println("Mesh");
                System.err.println("Name:\t" + info.getName());
                System.err.println("Mittelpunkt:\t" + orig.toString());
                System.err.println();
            }
        } else if (obj.getObject() instanceof ObjectCollection) {
            Enumeration objects = ((ObjectCollection)obj.getObject()).getObjects(obj, false, theScene);
            while (objects.hasMoreElements()) {
                POVExporter.writeObjects(theScene, (ObjectInfo)objects.nextElement(), out, smooth, tolerance);
            }
        } else {
            POVExporter.write("// smoothed object", out, 0);
            ObjectInfo info = obj.duplicate();
            RenderingMesh mesh = info.getRenderingMesh(tolerance);
            POVExporter.write("// " + info.getName(), out, 0);
            if (mesh != null) {
                int j;
                Vec3[] vert = mesh.vert;
                Vec3[] norm = mesh.norm;
                RenderingTriangle[] face = mesh.triangle;
                CoordinateSystem coords = info.getCoords();
                Vec3 orig = coords.getOrigin();
                String texName = POVExporter.cleanName(info.getObject().getTexture().getName());
                if (info.getObject().getTexture().getID() == 1) {
                    texName = POVExporter.cleanName(info.getName());
                }
                POVExporter.write("mesh2 {", out, 0);
                POVExporter.write("vertex_vectors {", out, 1);
                POVExporter.write(vert.length + ",", out, 2);
                for (j = 0; j < vert.length; ++j) {
                    if (j != vert.length - 1) {
                        POVExporter.write(POVExporter.getVec3String(vert[j]) + ",", out, 2);
                        continue;
                    }
                    POVExporter.write(POVExporter.getVec3String(vert[j]), out, 2);
                }
                POVExporter.write("}", out, 1);
                POVExporter.write("normal_vectors {", out, 1);
                POVExporter.write(norm.length + ",", out, 2);
                for (j = 0; j < norm.length; ++j) {
                    if (j != norm.length - 1) {
                        POVExporter.write(POVExporter.getVec3String(norm[j]) + ",", out, 2);
                        continue;
                    }
                    POVExporter.write(POVExporter.getVec3String(norm[j]), out, 2);
                }
                POVExporter.write("}", out, 1);
                POVExporter.write("face_indices {", out, 1);
                POVExporter.write(face.length + ",", out, 2);
                for (j = 0; j < face.length; ++j) {
                    if (j != face.length - 1) {
                        POVExporter.write("<" + face[j].v1 + "," + face[j].v2 + "," + face[j].v3 + "> ,", out, 2);
                        continue;
                    }
                    POVExporter.write("<" + face[j].v1 + "," + face[j].v2 + "," + face[j].v3 + ">", out, 2);
                }
                POVExporter.write("}", out, 1);
                POVExporter.write("normal_indices {", out, 1);
                POVExporter.write(face.length + ",", out, 2);
                for (j = 0; j < face.length; ++j) {
                    if (j != face.length - 1) {
                        POVExporter.write("<" + face[j].n1 + "," + face[j].n2 + "," + face[j].n3 + "> ,", out, 2);
                        continue;
                    }
                    POVExporter.write("<" + face[j].n1 + "," + face[j].n2 + "," + face[j].n3 + ">", out, 2);
                }
                POVExporter.write("}", out, 1);
                POVExporter.write("texture { AOI" + texName + " }", out, 1);
                POVExporter.writeRotation(coords, out, 1);
                POVExporter.write("translate " + POVExporter.getVec3String(orig), out, 1);
                POVExporter.write("}", out, 0);
                POVExporter.write("", out, 0);
                if (DEBUG) {
                    System.err.println("Mesh");
                    System.err.println("Name:\t" + info.getName());
                    System.err.println("Mittelpunkt:\t" + orig.toString());
                    System.err.println();
                }
            }
            POVExporter.write("", out, 0);
        }
    }
}

