/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ArtOfIllusion;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMapping;
import artofillusion.translators.TextureImageExporter;
import artofillusion.translators.TextureImageInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class OBJExporter {
    public static void exportFile(BFrame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        final ValueField widthField = new ValueField(200.0, 7);
        final ValueField heightField = new ValueField(200.0, 7);
        final ValueSlider qualitySlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        BCheckBox smoothBox = new BCheckBox(Translate.text((String)"subdivideSmoothMeshes"), true);
        BCheckBox normalsBox = new BCheckBox(Translate.text((String)"alwaysWriteNormals"), false);
        final BCheckBox mtlBox = new BCheckBox(Translate.text((String)"writeTexToMTL"), false);
        BComboBox exportChoice = new BComboBox((Object[])new String[]{Translate.text((String)"exportWholeScene"), Translate.text((String)"selectedObjectsOnly")});
        mtlBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                widthField.setEnabled(mtlBox.getState());
                heightField.setEnabled(mtlBox.getState());
                qualitySlider.setEnabled(mtlBox.getState());
            }
        });
        mtlBox.dispatchEvent((Object)new ValueChangedEvent((Widget)mtlBox));
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToOBJ"), new Widget[]{exportChoice, errorField, smoothBox, normalsBox, mtlBox, Translate.label((String)"imageSizeForTextures"), widthField, heightField, qualitySlider}, new String[]{null, Translate.text((String)"maxSurfaceError"), null, null, null, null, Translate.text((String)"Width"), Translate.text((String)"Height"), Translate.text((String)"imageQuality")}) : new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToOBJ"), new Widget[]{errorField, smoothBox, normalsBox, mtlBox, Translate.label((String)"imageSizeForTextures"), widthField, heightField, qualitySlider}, new String[]{Translate.text((String)"maxSurfaceError"), null, null, null, null, Translate.text((String)"Width"), Translate.text((String)"Height"), Translate.text((String)"imageQuality")});
        if (!dlg.clickedOk()) {
            return;
        }
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text((String)"exportToOBJ"));
        fc.setSelectedFile(new File("Untitled.obj"));
        if (ArtOfIllusion.getCurrentDirectory() != null) {
            fc.setDirectory(new File(ArtOfIllusion.getCurrentDirectory()));
        }
        if (!fc.showDialog((Widget)parent)) {
            return;
        }
        File dir = fc.getDirectory();
        File f = fc.getSelectedFile();
        String name = f.getName();
        String baseName = name.endsWith(".obj") ? name.substring(0, name.length() - 4) : name;
        ArtOfIllusion.setCurrentDirectory((String)dir.getAbsolutePath());
        try {
            PrintWriter out;
            TextureImageExporter textureExporter = null;
            String mtlFilename = null;
            if (mtlBox.getState()) {
                textureExporter = new TextureImageExporter(dir, baseName, (int)(100.0 * qualitySlider.getValue()), 21, (int)widthField.getValue(), (int)heightField.getValue());
                mtlFilename = baseName.replace(' ', '_') + ".mtl";
                out = new PrintWriter(new BufferedWriter(new FileWriter(new File(dir, mtlFilename))));
                OBJExporter.writeTextures(theScene, out, exportChoice.getSelectedIndex() == 0, textureExporter);
                out.close();
                textureExporter.saveImages();
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            OBJExporter.writeScene(theScene, out, exportChoice.getSelectedIndex() == 0, errorField.getValue(), smoothBox.getState(), normalsBox.getState(), textureExporter, mtlFilename);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new BStandardDialog("", (Object)new String[]{Translate.text((String)"errorExportingScene"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog((Widget)parent);
        }
    }

    public static void writeScene(Scene theScene, PrintWriter out, boolean wholeScene, double tol, boolean smooth, boolean alwaysStoreNormals, TextureImageExporter textureExporter, String mtlFilename) {
        out.println("#Produced by Art of Illusion " + ArtOfIllusion.getVersion() + ", " + new Date().toString());
        if (mtlFilename != null) {
            out.println("mtllib " + mtlFilename);
        }
        int numVert = 0;
        int numNorm = 0;
        int numTexVert = 0;
        Hashtable<String, String> groupNames = new Hashtable<String, String>();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        nf.setGroupingUsed(false);
        for (int i = 0; i < theScene.getNumObjects(); ++i) {
            int j;
            double vscale;
            Vec3 v;
            int j2;
            String baseName;
            Vec3[] norm;
            Object mesh;
            ObjectInfo info = theScene.getObject(i);
            if (!wholeScene && !info.selected || info.getObject().getTexture() == null || (mesh = !smooth && info.getObject() instanceof FacetedMesh ? (FacetedMesh)info.getObject() : info.getObject().convertToTriangleMesh(tol)) == null) continue;
            int[][] normIndex = new int[mesh.getFaceCount()][];
            if (mesh instanceof TriangleMesh) {
                RenderingMesh rm = mesh.getRenderingMesh(Double.MAX_VALUE, false, info);
                norm = rm.norm;
                for (int j3 = 0; j3 < normIndex.length; ++j3) {
                    normIndex[j3] = new int[]{rm.triangle[j3].n1, rm.triangle[j3].n2, rm.triangle[j3].n3};
                }
            } else {
                norm = mesh.getNormals();
                for (int j4 = 0; j4 < normIndex.length; ++j4) {
                    normIndex[j4] = new int[mesh.getFaceVertexCount(j4)];
                    for (int k = 0; k < normIndex[j4].length; ++k) {
                        normIndex[j4][k] = mesh.getFaceVertexIndex(j4, k);
                    }
                }
            }
            MeshVertex[] vert = mesh.getVertices();
            boolean needNormals = false;
            if (alwaysStoreNormals) {
                needNormals = true;
            } else {
                for (int j5 = 0; j5 < normIndex.length && !needNormals; ++j5) {
                    for (int k = 1; k < normIndex[j5].length; ++k) {
                        if (norm[normIndex[j5][k]].equals(norm[normIndex[j5][0]])) continue;
                        needNormals = true;
                    }
                }
                if (!needNormals) {
                    out.println("s 0");
                } else {
                    needNormals = false;
                    Vec3[] vertNormal = new Vec3[vert.length];
                    for (int j6 = 0; j6 < mesh.getFaceCount() && !needNormals; ++j6) {
                        for (int k = 0; k < mesh.getFaceVertexCount(j6); ++k) {
                            Vec3 n = norm[normIndex[j6][k]];
                            int index = mesh.getFaceVertexIndex(j6, k);
                            if (vertNormal[index] == null) {
                                vertNormal[index] = n;
                                continue;
                            }
                            if (n.equals(vertNormal[index])) continue;
                            needNormals = true;
                        }
                    }
                    if (!needNormals) {
                        out.println("s 1");
                    }
                }
            }
            String name = baseName = info.getName().replace(' ', '_');
            int append = 1;
            while (groupNames.get(name) != null) {
                name = baseName + "_" + append++;
            }
            groupNames.put(name, "");
            out.println("g " + name);
            TextureImageInfo ti = null;
            if (textureExporter != null && (ti = textureExporter.getTextureInfo(info.getObject().getTexture())) != null) {
                out.println("usemtl " + ti.name);
            }
            Mat4 trans = info.getCoords().fromLocal();
            for (j2 = 0; j2 < vert.length; ++j2) {
                v = trans.times(vert[j2].r);
                out.println("v " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
            }
            if (needNormals) {
                for (j2 = 0; j2 < norm.length; ++j2) {
                    if (norm[j2] == null) {
                        out.println("vn 1 0 0");
                        continue;
                    }
                    v = trans.timesDirection(norm[j2]);
                    out.println("vn " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                }
            }
            if (ti != null && ((Object3D)mesh).getTextureMapping() instanceof UVMapping && ((UVMapping)((Object3D)mesh).getTextureMapping()).isPerFaceVertex((FacetedMesh)mesh)) {
                int k;
                Vec2[][] coords = ((UVMapping)((Object3D)mesh).getTextureMapping()).findFaceTextureCoordinates((FacetedMesh)mesh);
                double uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
                vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
                for (j = 0; j < coords.length; ++j) {
                    for (k = 0; k < coords[j].length; ++k) {
                        double u = (coords[j][k].x - ti.minu) * uscale;
                        double v2 = (coords[j][k].y - ti.minv) * vscale;
                        out.println("vt " + nf.format(u) + " " + nf.format(v2));
                    }
                }
                for (j = 0; j < mesh.getFaceCount(); ++j) {
                    out.print("f ");
                    for (k = 0; k < mesh.getFaceVertexCount(j); ++k) {
                        int vertIndex = mesh.getFaceVertexIndex(j, k) + 1;
                        if (k > 0) {
                            out.print(' ');
                        }
                        out.print(vertIndex + numVert);
                        out.print('/');
                        out.print(k + 1 + numTexVert);
                        if (!needNormals) continue;
                        out.print('/');
                        out.print(normIndex[j][k] + numNorm + 1);
                    }
                    out.println();
                    numTexVert += coords[j].length;
                }
            } else if (ti != null && ((Object3D)mesh).getTextureMapping() instanceof Mapping2D) {
                Vec2[] coords = ((Mapping2D)((Object3D)mesh).getTextureMapping()).findTextureCoordinates((Mesh)mesh);
                double uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
                vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
                for (j = 0; j < coords.length; ++j) {
                    double u = (coords[j].x - ti.minu) * uscale;
                    double v3 = (coords[j].y - ti.minv) * vscale;
                    out.println("vt " + nf.format(u) + " " + nf.format(v3));
                }
                for (j = 0; j < mesh.getFaceCount(); ++j) {
                    out.print("f ");
                    for (int k = 0; k < mesh.getFaceVertexCount(j); ++k) {
                        int vertIndex = mesh.getFaceVertexIndex(j, k) + 1;
                        if (k > 0) {
                            out.print(' ');
                        }
                        out.print(vertIndex + numVert);
                        out.print('/');
                        out.print(vertIndex + numTexVert);
                        if (!needNormals) continue;
                        out.print('/');
                        out.print(normIndex[j][k] + numNorm + 1);
                    }
                    out.println();
                }
                numTexVert += coords.length;
            } else {
                for (j2 = 0; j2 < mesh.getFaceCount(); ++j2) {
                    out.print("f ");
                    for (int k = 0; k < mesh.getFaceVertexCount(j2); ++k) {
                        int vertIndex = mesh.getFaceVertexIndex(j2, k) + 1;
                        if (k > 0) {
                            out.print(' ');
                        }
                        out.print(vertIndex + numVert);
                        if (!needNormals) continue;
                        out.print("//");
                        out.print(normIndex[j2][k] + numNorm + 1);
                    }
                    out.println();
                }
            }
            numVert += vert.length;
            if (!needNormals) continue;
            numNorm += norm.length;
        }
    }

    private static void writeTextures(Scene theScene, PrintWriter out, boolean wholeScene, TextureImageExporter textureExporter) {
        for (int i = 0; i < theScene.getNumObjects(); ++i) {
            ObjectInfo info = theScene.getObject(i);
            if (!wholeScene && !info.selected) continue;
            textureExporter.addObject(info);
        }
        out.println("#Produced by Art of Illusion " + ArtOfIllusion.getVersion() + ", " + new Date().toString());
        Enumeration textures = textureExporter.getTextures();
        Hashtable<String, TextureImageInfo> names = new Hashtable<String, TextureImageInfo>();
        TextureSpec spec = new TextureSpec();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        while (textures.hasMoreElements()) {
            TextureImageInfo info = (TextureImageInfo)textures.nextElement();
            String baseName = info.texture.getName().replace(' ', '_');
            if (names.get(baseName) == null) {
                info.name = baseName;
            } else {
                int i = 1;
                while (names.get(baseName + i) != null) {
                    ++i;
                }
                info.name = baseName + i;
            }
            names.put(info.name, info);
            out.println("newmtl " + info.name);
            info.texture.getAverageSpec(spec, 0.0, info.paramValue);
            if (info.diffuseFilename == null) {
                out.println("Kd " + nf.format(spec.diffuse.getRed()) + " " + nf.format(spec.diffuse.getGreen()) + " " + nf.format(spec.diffuse.getBlue()));
            } else {
                out.println("Kd 1 1 1");
                out.println("map_Kd " + info.diffuseFilename);
            }
            if (info.hilightFilename == null) {
                out.println("Ks " + nf.format(spec.hilight.getRed()) + " " + nf.format(spec.hilight.getGreen()) + " " + nf.format(spec.hilight.getBlue()));
            } else {
                out.println("Ks 1 1 1");
                out.println("map_Ks " + info.hilightFilename);
            }
            if (info.emissiveFilename == null) {
                out.println("Ka " + nf.format(spec.emissive.getRed()) + " " + nf.format(spec.emissive.getGreen()) + " " + nf.format(spec.emissive.getBlue()));
            } else {
                out.println("Ka 1 1 1");
                out.println("map_Ka " + info.emissiveFilename);
            }
            if (info.hilightFilename == null && spec.hilight.getRed() == 0.0f && spec.hilight.getGreen() == 0.0f && spec.hilight.getBlue() == 0.0f) {
                out.println("illum 1");
                continue;
            }
            out.println("illum 2");
            out.println("Ns " + (int)((1.0 - spec.roughness) * 128.0 + 1.0));
        }
    }
}

