/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.PointLight;
import artofillusion.object.SpotLight;
import artofillusion.raytracer.RTLight;
import artofillusion.raytracer.Ray;

public class RTSphericalLight
extends RTLight {
    private final double radius;

    public RTSphericalLight(PointLight light, CoordinateSystem coords, boolean softShadows) {
        super((Light)light, coords);
        this.radius = softShadows ? light.getRadius() : 0.0;
    }

    public RTSphericalLight(SpotLight light, CoordinateSystem coords, boolean softShadows) {
        super((Light)light, coords);
        this.radius = softShadows ? light.getRadius() : 0.0;
    }

    public double findRayToLight(Vec3 origin, Ray ray, int rayNumber) {
        ray.getOrigin().set(origin);
        Vec3 dir = ray.getDirection();
        dir.set(this.getCoords().getOrigin());
        if (rayNumber != -1) {
            ray.rt.rt.randomizePoint(dir, ray.rt.random, this.radius, rayNumber);
        }
        dir.subtract(origin);
        double distToLight = dir.length();
        dir.normalize();
        return distToLight;
    }
}

